/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import net.dries007.tfc.mixin.accessor.StructureTemplateAccessor;
import net.dries007.tfc.world.feature.tree.RandomTreeConfig;
import net.dries007.tfc.world.feature.tree.TreeHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class RandomTreeFeature
extends Feature<RandomTreeConfig> {
    public RandomTreeFeature(Codec<RandomTreeConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RandomTreeConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        RandomTreeConfig config = (RandomTreeConfig)context.config();
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        StructureTemplateManager manager = TreeHelpers.getStructureManager(level);
        StructurePlaceSettings settings = TreeHelpers.getPlacementSettings((LevelHeightAccessor)level, chunkPos, random);
        ResourceLocation structureId = config.structureNames().get(random.nextInt(config.structureNames().size()));
        StructureTemplate structure = manager.getOrCreate(structureId);
        if (((StructureTemplateAccessor)structure).accessor$getPalettes().isEmpty()) {
            throw new IllegalStateException("Empty structure: " + String.valueOf(structureId));
        }
        if (TreeHelpers.isValidLocation((LevelAccessor)level, pos, settings, config.placement())) {
            boolean placeTree = config.rootSystem().map(roots -> TreeHelpers.placeRoots(level, mutablePos, roots, random) || !roots.required()).orElse(true);
            if (placeTree) {
                config.trunk().ifPresent(trunk -> {
                    int height = TreeHelpers.placeTrunk(level, (BlockPos)mutablePos, random, settings, trunk);
                    mutablePos.move(0, height, 0);
                });
                TreeHelpers.placeTemplate(structure, settings, (ServerLevelAccessor)level, mutablePos.subtract((Vec3i)TreeHelpers.transformCenter(structure.getSize(), settings)));
                return true;
            }
            return false;
        }
        return false;
    }
}

