/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.feature.tree.StackedTreeConfig;
import net.dries007.tfc.world.feature.tree.TreeHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class StackedTreeFeature
extends Feature<StackedTreeConfig> {
    public StackedTreeFeature(Codec<StackedTreeConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<StackedTreeConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        StackedTreeConfig config = (StackedTreeConfig)context.config();
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        StructureTemplateManager manager = TreeHelpers.getStructureManager(level);
        StructurePlaceSettings settings = TreeHelpers.getPlacementSettings((LevelHeightAccessor)level, chunkPos, random);
        if (TreeHelpers.isValidGround((LevelAccessor)level, pos, settings, config.placement())) {
            boolean placeTree;
            boolean bl = placeTree = config.rootSystem().isPresent() && (TreeHelpers.placeRoots(level, mutablePos, config.rootSystem().get(), random) || !config.rootSystem().get().required()) || config.rootSystem().isEmpty();
            if (placeTree) {
                config.rootSystem().ifPresent(roots -> TreeHelpers.placeRoots(level, mutablePos, roots, random));
                int trunkHeight = TreeHelpers.placeTrunk(level, (BlockPos)mutablePos, random, settings, config.trunk());
                mutablePos.move(0, trunkHeight, 0);
                for (StackedTreeConfig.Layer layer : config.layers()) {
                    int layerCount = layer.getCount(random);
                    for (int i = 0; i < layerCount; ++i) {
                        ResourceLocation structureId = layer.templates().get(random.nextInt(layer.templates().size()));
                        StructureTemplate structure = manager.getOrCreate(structureId);
                        TreeHelpers.placeTemplate(structure, settings, (ServerLevelAccessor)level, mutablePos.subtract((Vec3i)TreeHelpers.transformCenter(structure.getSize(), settings)));
                        mutablePos.move(0, structure.getSize().getY(), 0);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

