/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.vein.DiscVeinConfig;
import net.dries007.tfc.world.feature.vein.DiscVeinFeature;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class KaolinDiscVeinFeature
extends DiscVeinFeature {
    public KaolinDiscVeinFeature(Codec<DiscVeinConfig> codec) {
        super(codec);
    }

    @Override
    @Nullable
    protected BlockState getStateToGenerate(BlockState stoneState, RandomSource random, DiscVeinConfig config, int x, int y, int z) {
        if (Helpers.isBlock(stoneState, TFCTags.Blocks.GRASS)) {
            return ((Block)TFCBlocks.KAOLIN_CLAY_GRASS.get()).defaultBlockState();
        }
        if (Helpers.isBlock(stoneState, TFCTags.Blocks.KAOLIN_CLAY_REPLACEABLE)) {
            if (y > -2) {
                return ((Block)TFCBlocks.RED_KAOLIN_CLAY.get()).defaultBlockState();
            }
            if (y > -4) {
                return ((Block)TFCBlocks.PINK_KAOLIN_CLAY.get()).defaultBlockState();
            }
            return ((Block)TFCBlocks.WHITE_KAOLIN_CLAY.get()).defaultBlockState();
        }
        return null;
    }

    @Override
    protected float getChanceToGenerate(int x, int y, int z, DiscVeinFeature.Vein vein, DiscVeinConfig config) {
        float sample = (float)vein.metaballs().sample(x, z);
        if (Math.abs(y) <= config.height() && sample > 1.0f) {
            return config.config().density() * Mth.clampedMap((float)sample, (float)2.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        }
        return 0.0f;
    }
}

