/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.layer.framework.AreaContext;
import net.dries007.tfc.world.layer.framework.CenterTransformLayer;
import net.minecraft.util.RandomSource;

public enum ForestRandomizeLayer implements CenterTransformLayer
{
    INSTANCE;


    @Override
    public int apply(AreaContext context, int value) {
        ForestType current = ForestType.valueOf(value);
        RandomSource source = context.random();
        if (current.isNone()) {
            int random = source.nextInt(20);
            if (random <= 2) {
                return ForestType.SHRUBLAND.ordinal();
            }
            if (random <= 5) {
                return ForestType.getSavannaForestType(source);
            }
            if (random == 6) {
                return ForestType.getSecondaryForestType(source);
            }
        } else if (current.isSavanna()) {
            int random = source.nextInt(16);
            if (random <= 2) {
                return ForestType.getSecondaryForestType(source);
            }
            if (random <= 6) {
                return ForestType.SPARSE.ordinal();
            }
            if (random <= 8) {
                return ForestType.SHRUBLAND.ordinal();
            }
        } else if (current.isPrimary() || current.isSecondary()) {
            int random = source.nextInt(24);
            if (random == 0) {
                return ForestType.SECONDARY_BAMBOO.ordinal();
            }
            if (random == 1 && !current.isSecondary()) {
                return ForestType.getSavannaForestType(source);
            }
            if (random == 2) {
                return ForestType.SHRUBLAND.ordinal();
            }
            if (random <= 6) {
                return ForestType.getPrimaryForestType(source);
            }
        }
        return value;
    }
}

