/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer.framework;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import net.dries007.tfc.world.layer.framework.AreaSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;

public class Area {
    private final AreaSource source;
    private final long[] keys;
    private final int[] values;
    private final int mask;

    public Area(AreaSource source, int maxCacheSize) {
        maxCacheSize = Mth.smallestEncompassingPowerOfTwo((int)maxCacheSize);
        this.source = source;
        this.keys = new long[maxCacheSize];
        this.values = new int[maxCacheSize];
        this.mask = maxCacheSize - 1;
        Arrays.fill(this.keys, Long.MIN_VALUE);
    }

    public int get(int x, int z) {
        int value;
        long key = ChunkPos.asLong((int)x, (int)z);
        int index = (int)HashCommon.mix((long)key) & this.mask;
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.values[index] = value = this.source.apply(x, z);
        this.keys[index] = key;
        return value;
    }
}

