/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer.framework;

import it.unimi.dsi.fastutil.HashCommon;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;

public class AreaContext {
    private final long seed;
    private final RandomSource random;

    public AreaContext(long seed) {
        this.seed = HashCommon.murmurHash3((long)seed);
        this.random = new XoroshiroRandomSource(seed);
    }

    public RandomSource random() {
        return this.random;
    }

    public void setSeed(long x, long z) {
        this.random.setSeed((x * 501125321L ^ z * 1136930381L ^ this.seed) * 668265261L);
    }

    public int choose(int first, int second) {
        return this.random.nextBoolean() ? first : second;
    }

    public int choose(int first, int second, int third, int fourth) {
        return switch (this.random.nextInt(4)) {
            case 0 -> first;
            case 1 -> second;
            case 2 -> third;
            default -> fourth;
        };
    }

    public int choose(int[] choices) {
        return choices[this.random.nextInt(choices.length)];
    }

    public <A> A choose(A first, A second) {
        return this.random.nextBoolean() ? first : second;
    }

    public <A> A choose(A first, A second, A third, A fourth) {
        return switch (this.random.nextInt(4)) {
            case 0 -> first;
            case 1 -> second;
            case 2 -> third;
            default -> fourth;
        };
    }

    public <A> A choose(A[] choices) {
        return choices[this.random.nextInt(choices.length)];
    }
}

