/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ShallowWaterPlacement
extends PlacementModifier {
    public static final MapCodec<ShallowWaterPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codecs.POSITIVE_INT.optionalFieldOf("min_depth", (Object)0).forGetter(c -> c.minDepth), (App)Codecs.POSITIVE_INT.optionalFieldOf("max_depth", (Object)5).forGetter(c -> c.maxDepth)).apply((Applicative)instance, ShallowWaterPlacement::new));
    private final int minDepth;
    private final int maxDepth;

    public ShallowWaterPlacement(int minDepth, int maxDepth) {
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (int i = 0; i < this.maxDepth; ++i) {
            mutablePos.move(0, -1, 0);
            if (context.getLevel().isFluidAtPosition((BlockPos)mutablePos, state -> Helpers.isFluid(state, TFCTags.Fluids.ANY_INFINITE_WATER))) continue;
            if (i < this.minDepth) {
                return Stream.empty();
            }
            return (double)random.nextFloat() > (double)i / (double)this.maxDepth ? Stream.of(pos) : Stream.empty();
        }
        return Stream.empty();
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)TFCPlacements.SHALLOW_WATER.get();
    }
}

