/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum AddHotspots implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        double threshold = 0.65;
        double expansionThreshold = 0.15;
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        for (Region.Point point : region.points()) {
            byte age;
            if (!(context.generator().continentFactor(point) > 0.5f)) continue;
            Cellular2D.Cell cell = context.generator().plateRegionNoise.cell(point.x, point.z);
            double edgeDist = Math.abs(cell.f1() - cell.f2());
            double val = context.generator().hotSpotIntensityNoise.noise(this.shift(point.x), this.shift(point.z));
            if (!(val > 0.65) || !(edgeDist > 0.05)) continue;
            point.hotSpotAge = age = (byte)context.generator().hotSpotAgeNoise.noise(this.shift(point.x), this.shift(point.z));
            if (age != 4) {
                point.setLand();
            }
            queue.enqueue(point.index);
        }
        while (!queue.isEmpty()) {
            int index = queue.dequeueInt();
            byte lastAge = region.atIndex((int)index).hotSpotAge;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    Region.Point next = region.atOffset(index, dx, dz);
                    if (next == null || next.hotSpotAge != 0) continue;
                    if (context.generator().hotSpotIntensityNoise.noise(this.shift(next.x), this.shift(next.z)) > 0.15) {
                        queue.enqueue(next.index);
                        next.hotSpotAge = lastAge;
                        if (lastAge == 4) continue;
                        next.setLand();
                        continue;
                    }
                    if (next.land() || !(context.generator().hotSpotIntensityNoise.noise(this.shift(next.x) - (double)dx, this.shift(next.z) - (double)dz) > 0.15)) continue;
                    next.hotSpotAge = lastAge;
                    if (lastAge == 4) continue;
                    next.setLand();
                }
            }
        }
    }

    public double shift(int point) {
        return (double)point + 0.5;
    }
}

