/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import java.util.HashMap;
import java.util.List;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.river.River;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.jetbrains.annotations.Nullable;

public enum AddRiversAndLakes implements RegionTask
{
    INSTANCE;

    public static final float RIVER_LENGTH = 2.7f;
    public static final int RIVER_DEPTH = 17;
    public static final float RIVER_FEATHER = 0.8f;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        RandomSource random = context.random;
        RegionRiverGenerator riverGenerator = new RegionRiverGenerator(region);
        this.createInitialDrains(context, region, riverGenerator);
        List<RiverEdge> rivers = riverGenerator.build(e -> new RiverEdge((River.Edge)e, random));
        context.region.setRivers(rivers);
        if (!rivers.isEmpty()) {
            this.annotateRiver(region, random, rivers);
        }
    }

    private void createInitialDrains(RegionGenerator.Context context, Region region, RegionRiverGenerator riverGenerator) {
        for (Region.Point point : region.points()) {
            float bestAngle;
            if (!point.shore() || Float.isNaN(bestAngle = this.findBestStartingAngle(region, context.random, point.index))) continue;
            XoroshiroRandomSource rng = new XoroshiroRandomSource(context.random.nextLong());
            riverGenerator.add(new River.Builder((RandomSource)rng, (float)point.x + 0.5f, (float)point.z + 0.5f, bestAngle, 2.7f, 17, 0.8f));
            point.setRiver();
        }
    }

    private float findBestStartingAngle(Region region, RandomSource random, int index) {
        float bestDistanceMetric = Float.MIN_VALUE;
        int bestDistanceCount = 0;
        float bestAngle = Float.NaN;
        for (int dirX = -1; dirX <= 1; ++dirX) {
            for (int dirZ = -1; dirZ <= 1; ++dirZ) {
                float dirDistanceMetric;
                Region.Point dirPoint;
                if (dirX == 0 && dirZ == 0 || (dirPoint = region.atOffset(index, 4 * dirX, 4 * dirZ)) == null || !dirPoint.land() || !((dirDistanceMetric = (float)(dirPoint.distanceToOcean - Math.abs(dirX) - Math.abs(dirZ))) > bestDistanceMetric) && (dirDistanceMetric != bestDistanceMetric || random.nextInt(1 + bestDistanceCount) != 0)) continue;
                if (dirDistanceMetric > bestDistanceMetric) {
                    bestDistanceMetric = dirDistanceMetric;
                    bestDistanceCount = 0;
                }
                ++bestDistanceCount;
                bestAngle = (float)Math.atan2(dirZ, dirX);
            }
        }
        if (!Float.isNaN(bestAngle)) {
            bestAngle += random.nextFloat() * 0.2f - 0.1f;
        }
        return bestAngle;
    }

    private void annotateRiver(Region region, RandomSource random, List<RiverEdge> rivers) {
        HashMap<River.Vertex, RiverEdge> sourceVertexToEdge = new HashMap<River.Vertex, RiverEdge>();
        for (RiverEdge edge : rivers) {
            sourceVertexToEdge.put(edge.source(), edge);
        }
        for (RiverEdge edge : rivers) {
            edge.linkToDrain((RiverEdge)sourceVertexToEdge.get(edge.drain()));
        }
        for (RiverEdge edge : rivers) {
            if (edge.sourceEdge()) continue;
            int width = 8;
            while (edge != null) {
                edge.width = Math.max(edge.width, width);
                edge = edge.drainEdge();
                width = Math.min(width + 2, 24);
            }
        }
        for (RiverEdge edge : rivers) {
            if (edge.sourceEdge() || random.nextInt(3) != 0) continue;
            this.placeLakeNear(region, edge, 1, 1);
            this.placeLakeNear(region, edge, -1, 1);
            this.placeLakeNear(region, edge, 1, -1);
            this.placeLakeNear(region, edge, -1, -1);
        }
    }

    private void placeLakeNear(Region region, RiverEdge edge, int offsetX, int offsetZ) {
        int gridZ;
        int gridX = (int)(edge.source().x() + (double)(0.3f * (float)offsetX));
        Region.Point point = region.at(gridX, gridZ = (int)(edge.source().y() + (double)(0.3f * (float)offsetZ)));
        if (point != null && point.land() && point.distanceToOcean >= 2 && point.distanceToEdge >= 2 && TFCLayers.hasLake(point.biome)) {
            point.biome = TFCLayers.lakeFor(point.biome);
            point.rainfall += 0.09f * (500.0f - point.rainfall);
        }
    }

    static class RegionRiverGenerator
    extends River.MultiParallelBuilder {
        private final Region region;

        RegionRiverGenerator(Region region) {
            this.region = region;
        }

        @Override
        protected boolean isLegal(River.Vertex prev, River.Vertex vertex) {
            Region.Point prevPoint = this.vertex2Point(prev);
            Region.Point newPoint = this.vertex2Point(vertex);
            return newPoint != null && prevPoint != null && newPoint.land() && newPoint.distanceToOcean >= prevPoint.distanceToOcean && newPoint.distanceToOcean >= Math.min(3, prev.distance() / 2);
        }

        @Nullable
        private Region.Point vertex2Point(River.Vertex vertex) {
            int gridX = (int)Math.round(vertex.x());
            int gridZ = (int)Math.round(vertex.y());
            return this.region.at(gridX, gridZ);
        }
    }
}

