/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public enum AnnotateDistanceToWestCoast implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        for (int dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                int index = dx + region.sizeX() * dz;
                Region.Point point = region.atIndex(index);
                if (point == null) continue;
                if (dx == 0) {
                    point.distanceToWestCoast = 0;
                    continue;
                }
                Region.Point lastCenterPoint = region.atIndex(index - 1);
                if (lastCenterPoint == null) {
                    point.distanceToWestCoast = point.land() ? (byte)(25 + point.distanceToOcean) : (byte)0;
                    continue;
                }
                byte lastCenterVal = lastCenterPoint.distanceToWestCoast;
                if (!point.land()) {
                    point.distanceToWestCoast = (byte)Math.max(lastCenterVal - 2, 0);
                    continue;
                }
                int sum = 0;
                float scale = context.generator().settings.temperatureScale();
                float frequency = 128.0f / (2.0f * scale);
                float function = Math.abs(4.0f * frequency * (float)point.z - 4.0f * (float)Mth.floor((float)(frequency * (float)point.z + 0.75f))) - 1.0f;
                int start = -2 + ((double)function > 0.1 ? 1 : 0);
                int end = 2 - ((double)function < -0.1 ? 1 : 0);
                for (int dz2 = start; dz2 <= end; ++dz2) {
                    Region.Point lastPoint = region.atOffset(point.index, -1, dz2);
                    if (lastPoint != null) {
                        sum += lastPoint.distanceToWestCoast;
                        continue;
                    }
                    sum += lastCenterVal;
                }
                point.distanceToWestCoast = (byte)(Mth.ceil((float)((float)sum / (1.0f + (float)end - (float)start))) + 1);
            }
        }
        BitSet explored = new BitSet(region.size());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        for (Region.Point point : region.points()) {
            if (point == null || !point.land()) continue;
            explored.set(point.index);
            queue.enqueue(point.index);
        }
        while (!queue.isEmpty()) {
            byte lastDistance;
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.atIndex(last);
            int nextDistance = lastDistance + ((lastDistance = lastPoint.distanceToWestCoast) > 40 ? -1 : 1);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    @Nullable Region.Point point = region.atOffset(last, dx, dz);
                    if (point == null || point.distanceToWestCoast != 0) continue;
                    if (!explored.get(point.index)) {
                        point.distanceToWestCoast = (byte)nextDistance;
                        queue.enqueue(point.index);
                    }
                    explored.set(point.index);
                }
            }
        }
    }
}

