/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import org.jetbrains.annotations.Nullable;

public enum FloodFillSmallOceans implements RegionTask
{
    INSTANCE;

    private static final int SMALL_OCEAN_FILL_THRESHOLD = 180;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        BitSet explored = new BitSet(region.size());
        for (Region.Point point : region.points()) {
            if (point == null || point.land() || explored.get(point.index)) continue;
            this.floodFillSmallOcean(explored, point.index, region);
        }
    }

    private void floodFillSmallOcean(BitSet explored, int index, Region region) {
        IntOpenHashSet values = new IntOpenHashSet();
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        queue.enqueue(index);
        values.add(index);
        boolean unbounded = false;
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    @Nullable Region.Point point = region.atOffset(last, dx, dz);
                    if (point == null) {
                        unbounded = true;
                        continue;
                    }
                    if (point.land() || explored.get(point.index)) continue;
                    explored.set(point.index);
                    queue.enqueue(point.index);
                    values.add(point.index);
                }
            }
        }
        if (values.size() < 180 && !unbounded) {
            values.forEach(i -> region.atIndex(i).setLand());
        }
    }
}

