/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import java.util.BitSet;
import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum Init implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        BitSet cell = new BitSet(region.size());
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int dx = 0; dx <= 202; ++dx) {
            for (int dz = 0; dz <= 202; ++dz) {
                int gridX = context.region.minX() + dx;
                int gridZ = context.region.minZ() + dz;
                int index = region.index(gridX, gridZ);
                Cellular2D.Cell otherCell = context.generator().sampleCell(gridX, gridZ);
                if (otherCell.x() != context.regionCell.x() || otherCell.y() != context.regionCell.y()) continue;
                cell.set(index);
                if (gridX < minX) {
                    minX = gridX;
                }
                if (gridZ < minZ) {
                    minZ = gridZ;
                }
                if (gridX > maxX) {
                    maxX = gridX;
                }
                if (gridZ <= maxZ) continue;
                maxZ = gridZ;
            }
        }
        int modifiedSizeX = 1 + maxX - minX;
        int modifiedSizeZ = 1 + maxZ - minZ;
        int offsetX = minX - region.minX();
        int offsetZ = minZ - region.minZ();
        int prevSizeX = 203;
        context.region.setRegionArea(minX, minZ, maxX, maxZ);
        for (int dx = 0; dx < modifiedSizeX; ++dx) {
            for (int dz = 0; dz < modifiedSizeZ; ++dz) {
                if (!cell.get(offsetX + dx + 203 * (offsetZ + dz))) continue;
                region.init(minX + dx, minZ + dz);
            }
        }
    }
}

