/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.shore;

import java.util.function.Function;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.shore.ShoreNoise;
import net.dries007.tfc.world.shore.ShoreNoiseSampler;

public enum ShoreBlendType {
    NONE(seed -> ShoreNoiseSampler.NONE),
    CLASSIC(ShoreNoise::classic),
    SANDY(ShoreNoise::sandyBeach),
    EMBAYMENTS(ShoreNoise::embayments),
    UPPER_TERRACE(ShoreNoise::upperTerrace),
    LOWER_TERRACE(ShoreNoise::lowerTerrace),
    SETBACK_CLIFFS(ShoreNoise::setbackCliffs),
    DUNES(ShoreNoise::dunes),
    ROCKY_SHORES(ShoreNoise::rockyShores),
    SEA_STACKS(ShoreNoise::seaStacks);

    public static final ShoreBlendType[] ALL;
    public static final int SIZE;
    private final Function<Seed, ShoreNoiseSampler> factory;

    private ShoreBlendType(Function<Seed, ShoreNoiseSampler> factory) {
        this.factory = factory;
    }

    public ShoreNoiseSampler createNoiseSampler(Seed seed) {
        return this.factory.apply(seed);
    }

    static {
        ALL = ShoreBlendType.values();
        SIZE = ALL.length;
    }
}

