/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.placement.ClimatePlacement;
import net.dries007.tfc.world.structure.TFCStructureHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class ClimateStructurePlacement
extends RandomSpreadStructurePlacement {
    private static final MapCodec<ClimateSettings> CLIMATE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(ClimateSettings::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(ClimateSettings::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(ClimateSettings::randomSpreadType), (App)ClimatePlacement.CODEC.fieldOf("climate").forGetter(ClimateSettings::climate)).apply((Applicative)instance, ClimateSettings::new));
    public static final MapCodec<ClimateStructurePlacement> PLACEMENT_CODEC = RecordCodecBuilder.mapCodec(instance -> ClimateStructurePlacement.placementCodec((RecordCodecBuilder.Instance)instance).and((App)CLIMATE_CODEC.forGetter(c -> c.settings)).apply((Applicative)instance, ClimateStructurePlacement::new)).validate(ClimateStructurePlacement::validate);
    private final ClimateSettings settings;

    private static DataResult<ClimateStructurePlacement> validate(ClimateStructurePlacement placement) {
        return placement.spacing() <= placement.separation() ? DataResult.error(() -> "Spacing has to be larger than separation") : DataResult.success((Object)((Object)placement));
    }

    public ClimateStructurePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod freqReduction, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, ClimateSettings settings) {
        super(locateOffset, freqReduction, frequency, salt, exclusionZone, settings.spacing, settings.separation, settings.randomSpreadType);
        this.settings = settings;
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState state, int x, int z) {
        if (!super.isPlacementChunk(state, x, z)) {
            return false;
        }
        ChunkGeneratorExtension ex = ChunkGeneratorExtension.getFromStructureState(state);
        if (ex == null) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(x, z);
        int blockX = chunkPos.getMinBlockX();
        int blockZ = chunkPos.getMinBlockZ();
        BlockPos pos = new BlockPos(blockX, 0, blockZ);
        ChunkData data = ex.chunkDataGenerator().createAndGenerate(chunkPos);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.setLargeFeatureWithSalt(state.getLevelSeed(), x, z, this.salt());
        return this.settings.climate.isValidNonHemispheral(data, pos, (RandomSource)random);
    }

    public StructurePlacementType<?> type() {
        return (StructurePlacementType)TFCStructureHooks.CLIMATE.get();
    }

    public record ClimateSettings(int spacing, int separation, RandomSpreadType randomSpreadType, ClimatePlacement climate) {
    }
}

