/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.settings.RockSettings;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class SurfaceBuilderContext {
    private final LevelAccessor level;
    private final ChunkAccess chunk;
    private final ChunkData chunkData;
    private final RockData rockData;
    private final RandomSource random;
    private final int seaLevel;
    private final int minY;
    private final Set<BlockState> defaultBlockStates;
    private final Set<BlockState> defaultFluidStates;
    private final BlockPos.MutableBlockPos cursor;
    @Nullable
    private BiomeExtension biome;
    @Nullable
    private BiomeExtension originalBiome;
    private double biomeWeight;
    private double slope;
    private float temperature;
    private float baseGroundwater;
    private float rainfall;
    private float rainVariance;
    private boolean salty;

    public SurfaceBuilderContext(LevelAccessor level, ChunkAccess chunk, ChunkData chunkData, RandomSource random, RockLayerSettings rockLayerSettings, int seaLevel, int minY) {
        this.level = level;
        this.chunk = chunk;
        this.chunkData = chunkData;
        this.rockData = chunkData.getRockData();
        this.random = random;
        this.seaLevel = seaLevel;
        this.minY = minY;
        this.defaultBlockStates = new ObjectOpenHashSet();
        this.defaultFluidStates = new ObjectOpenHashSet();
        this.cursor = new BlockPos.MutableBlockPos();
        for (RockSettings rock : rockLayerSettings.getRocks()) {
            this.defaultBlockStates.add(rock.raw().defaultBlockState());
        }
        this.defaultFluidStates.add(Blocks.WATER.defaultBlockState());
    }

    public void buildSurface(BiomeExtension biome, BiomeExtension originalBiome, double biomeWeight, boolean salty, SurfaceBuilder builder, int x, int y, int z, double slope) {
        this.biome = biome;
        this.originalBiome = originalBiome;
        this.biomeWeight = biomeWeight;
        this.slope = slope;
        this.temperature = this.chunkData.getAverageSeaLevelTemp(x, z);
        this.baseGroundwater = this.chunkData.getBaseGroundwater(x, z);
        this.rainfall = this.chunkData.getRainfall(x, z);
        this.rainVariance = this.chunkData.getRainVariance(x, z);
        this.salty = salty;
        int oceanFloor = this.chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        int actualMinSurfaceHeight = Math.max(this.minY, Math.min(y, oceanFloor) - 20);
        this.cursor.set(x, 0, z);
        builder.buildSurface(this, y, actualMinSurfaceHeight);
    }

    public BiomeExtension biome() {
        assert (this.biome != null);
        return this.biome;
    }

    public BiomeExtension originalBiome() {
        assert (this.originalBiome != null);
        return this.originalBiome;
    }

    public double weight() {
        return this.biomeWeight;
    }

    public BlockPos pos() {
        return this.cursor;
    }

    public RockSettings getRock() {
        return this.rockData.getRock(this.cursor.getX(), this.cursor.getY(), this.cursor.getZ());
    }

    public RockSettings getSeaLevelRock() {
        return this.rockData.getRock(this.cursor.getX(), this.seaLevel, this.cursor.getZ());
    }

    public RockSettings getApproxSecondRock() {
        return this.rockData.getRock(this.cursor.getX(), Math.max(this.cursor.getY() - 64, -64), this.cursor.getZ());
    }

    public RockSettings getBottomRock() {
        return this.rockData.getRock(this.cursor.getX(), -64, this.cursor.getZ());
    }

    public float averageTemperature() {
        return this.temperature;
    }

    public float groundWater() {
        return this.baseGroundwater + this.rainfall;
    }

    public float baseGroundwater() {
        return this.baseGroundwater;
    }

    public float rainfall() {
        return this.rainfall;
    }

    public float rainVariance() {
        return this.rainVariance;
    }

    public boolean salty() {
        return this.salty;
    }

    public BlockState getBlockState(int y) {
        return this.chunk.getBlockState((BlockPos)this.cursor.setY(y));
    }

    public void setBlockState(int y, SurfaceState state) {
        this.cursor.setY(y);
        state.setState(this);
    }

    public void setBlockState(int y, BlockState state) {
        this.chunk.setBlockState((BlockPos)this.cursor.setY(y), state, false);
    }

    public LevelAccessor level() {
        return this.level;
    }

    public ChunkAccess chunk() {
        return this.chunk;
    }

    public ChunkData getChunkData() {
        return this.chunkData;
    }

    public RandomSource random() {
        return this.random;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public boolean isDefaultBlock(BlockState state) {
        return this.defaultBlockStates.contains(state);
    }

    public boolean isDefaultFluid(BlockState state) {
        return this.defaultFluidStates.contains(state);
    }

    public int calculateAltitudeSlopeSurfaceDepth(int y, int minimumReturnValue, int maxDepth) {
        double slopeFactor = 1.0 - Mth.clamp((double)(this.slope / 15.0), (double)0.0, (double)1.0);
        double seaLevelFactor = y < this.seaLevel ? Mth.clampedMap((double)((double)(this.seaLevel - y) / 15.0), (double)0.0, (double)0.4, (double)1.0, (double)1.4) : 1.0;
        int maxElevationDepth = y < this.seaLevel + 7 ? maxDepth : (int)Mth.clampedMap((float)y, (float)(this.seaLevel + 7), (float)(this.seaLevel + 67), (float)maxDepth, (float)2.0f);
        return Mth.clamp((int)((int)Mth.lerp((double)(slopeFactor * seaLevelFactor), (double)minimumReturnValue, (double)maxElevationDepth)), (int)minimumReturnValue, (int)maxElevationDepth);
    }

    public int calculateAltitudeSlopeSurfaceDepth(int y, int minimumReturnValue) {
        return this.calculateAltitudeSlopeSurfaceDepth(y, minimumReturnValue, 5);
    }
}

