/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import java.util.Arrays;
import net.dries007.tfc.common.blocks.SandstoneBlockType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.settings.RockSettings;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BadlandsSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory NORMAL = seed -> new BadlandsSurfaceBuilder(false, false, -1, seed);
    public static final SurfaceBuilderFactory MESAS = seed -> new BadlandsSurfaceBuilder(true, false, -3, seed);
    public static final SurfaceBuilderFactory HOODOOS = seed -> new BadlandsSurfaceBuilder(true, false, -7, seed);
    public static final SurfaceBuilderFactory WARPED = seed -> new BadlandsSurfaceBuilder(true, true, -20, seed);
    private static final int PRIMARY_SIZE = 8;
    private static final int SECONDARY_SIZE = 5;
    private static final int UNCOMMON_SIZE = 3;
    private static final int LAYER_SIZE = 16;
    private final boolean inverted;
    private final boolean dippingStrata;
    private final int soilMinDepth;
    private final BlockState[] sandLayers0;
    private final BlockState[] sandLayers1;
    private final BlockState[] sandLayersKarst;
    private final BlockState[] sandLayersVolcanic;
    private final BlockState[] sandstoneLayers0;
    private final BlockState[] sandstoneLayers1;
    private final BlockState[] sandstoneLayersKarst;
    private final BlockState[] sandstoneLayersVolcanic;
    private final float[] layerThresholds;
    private final Noise2D grassHeightVariationNoise;
    private final Noise2D sandHeightOffsetNoise;
    private final Noise2D sandStyleNoise;

    private static void fillBlocks(RandomSource random, BlockState[] sandLayers, BlockState[] sandstoneLayers, BlockState primaryStone, BlockState primarySand, BlockState secondaryStone, BlockState secondarySand, BlockState uncommonStone, BlockState uncommonSand) {
        BadlandsSurfaceBuilder.fill(random, sandLayers, primarySand, secondarySand, uncommonSand);
        BadlandsSurfaceBuilder.fill(random, sandstoneLayers, primaryStone, secondaryStone, uncommonStone);
    }

    private static void fillSand(RandomSource random, BlockState[] sandLayers, BlockState[] sandstoneLayers, SandBlockType primary, SandBlockType secondary, SandBlockType uncommon) {
        BadlandsSurfaceBuilder.fill(random, sandLayers, BadlandsSurfaceBuilder.sand(primary), BadlandsSurfaceBuilder.sand(secondary), BadlandsSurfaceBuilder.sand(uncommon));
        BadlandsSurfaceBuilder.fill(random, sandstoneLayers, BadlandsSurfaceBuilder.sandstone(primary), BadlandsSurfaceBuilder.sandstone(secondary), BadlandsSurfaceBuilder.sandstone(uncommon));
    }

    private static void fill(RandomSource random, BlockState[] layers, BlockState primary, BlockState secondary, BlockState uncommon) {
        Arrays.fill(layers, 0, 8, primary);
        Arrays.fill(layers, 8, 13, secondary);
        Arrays.fill(layers, 13, 16, uncommon);
        Helpers.shuffleArray(layers, random);
    }

    private static BlockState sand(SandBlockType color) {
        return ((Block)TFCBlocks.SAND.get((Object)color).get()).defaultBlockState();
    }

    private static BlockState sandstone(SandBlockType color) {
        return ((Block)TFCBlocks.SANDSTONE.get((Object)color).get((Object)SandstoneBlockType.RAW).get()).defaultBlockState();
    }

    private static BlockState gravel(Rock rock) {
        return rock.getBlock(Rock.BlockType.GRAVEL).get().defaultBlockState();
    }

    private static BlockState rock(Rock rock) {
        return rock.getBlock(Rock.BlockType.RAW).get().defaultBlockState();
    }

    private BlockState[] getKarstOrVolcanicSandLayer(BlockState[] defaultLayer, boolean karst, boolean volcanic) {
        return karst ? this.sandLayersKarst : (volcanic ? this.sandLayersVolcanic : defaultLayer);
    }

    private BlockState[] getKarstOrVolcanicSandstoneLayer(BlockState[] defaultLayer, boolean karst, boolean volcanic) {
        return karst ? this.sandstoneLayersKarst : (volcanic ? this.sandstoneLayersVolcanic : defaultLayer);
    }

    public BadlandsSurfaceBuilder(boolean inverted, boolean dippingStrata, int soilMinDepth, Seed seed) {
        this.inverted = inverted;
        this.dippingStrata = dippingStrata;
        this.soilMinDepth = soilMinDepth;
        RandomSource random = seed.fork();
        this.sandHeightOffsetNoise = dippingStrata ? new OpenSimplex2D(random.nextLong()).octaves(2).scaled(-250.0, 250.0).spread(0.005) : new OpenSimplex2D(random.nextLong()).octaves(2).scaled(0.0, 6.0).spread(0.0014f);
        this.sandLayers0 = new BlockState[16];
        this.sandLayers1 = new BlockState[16];
        this.sandLayersKarst = new BlockState[16];
        this.sandLayersVolcanic = new BlockState[16];
        this.sandstoneLayers0 = new BlockState[16];
        this.sandstoneLayers1 = new BlockState[16];
        this.sandstoneLayersKarst = new BlockState[16];
        this.sandstoneLayersVolcanic = new BlockState[16];
        this.layerThresholds = new float[16];
        BadlandsSurfaceBuilder.fillSand(random, this.sandLayers0, this.sandstoneLayers0, SandBlockType.RED, SandBlockType.BROWN, SandBlockType.YELLOW);
        BadlandsSurfaceBuilder.fillSand(random, this.sandLayers1, this.sandstoneLayers1, SandBlockType.BROWN, SandBlockType.YELLOW, SandBlockType.WHITE);
        BadlandsSurfaceBuilder.fillSand(random, this.sandLayersKarst, this.sandstoneLayersKarst, SandBlockType.RED, SandBlockType.YELLOW, SandBlockType.WHITE);
        BadlandsSurfaceBuilder.fillBlocks(random, this.sandLayersVolcanic, this.sandstoneLayersVolcanic, BadlandsSurfaceBuilder.sandstone(SandBlockType.BLACK), BadlandsSurfaceBuilder.sand(SandBlockType.BLACK), BadlandsSurfaceBuilder.rock(Rock.TUFF), BadlandsSurfaceBuilder.gravel(Rock.TUFF), BadlandsSurfaceBuilder.sandstone(SandBlockType.RED), BadlandsSurfaceBuilder.sand(SandBlockType.RED));
        for (int i = 0; i < 16; ++i) {
            this.layerThresholds[i] = random.nextFloat();
        }
        this.grassHeightVariationNoise = new OpenSimplex2D(random.nextLong()).octaves(2).scaled(77.0, 81.0).spread(0.5);
        this.sandStyleNoise = new OpenSimplex2D(random.nextLong()).octaves(2).scaled(-0.3f, 1.3f).spread(3.0E-4f);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        boolean volcanic;
        double heightVariation = this.grassHeightVariationNoise.noise(context.pos().getX(), context.pos().getZ());
        double weightVariation = (1.0 - context.weight()) * 23.0;
        double rainfallVariation = Mth.clampedMap((float)context.groundWater(), (float)100.0f, (float)500.0f, (float)0.0f, (float)22.0f);
        RockSettings rock = context.getRock();
        boolean karst = rock.karst().isPresent() ? rock.karst().get() : false;
        boolean bl = volcanic = rock.mafic().isPresent() ? rock.mafic().get() : false;
        if (this.inverted) {
            int shift = this.dippingStrata ? -10 : -16;
            this.buildSandStoneSurface(context, startY, endY, karst, volcanic, (int)((double)shift + heightVariation + weightVariation + rainfallVariation));
        } else if ((double)(startY - 5) > heightVariation - weightVariation - rainfallVariation) {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.TOP_GRASS_TO_SAND, SurfaceStates.MID_DIRT_TO_SAND, SurfaceStates.UNDER_GRAVEL);
        } else {
            this.buildSandySurface(context, startY, endY, karst, volcanic);
        }
    }

    private void buildSandySurface(SurfaceBuilderContext context, int startHeight, int minSurfaceHeight, boolean karst, boolean volcanic) {
        float style = (float)this.sandStyleNoise.noise(context.pos().getX(), context.pos().getZ());
        int height = (int)this.sandHeightOffsetNoise.noise(context.pos().getX(), context.pos().getZ());
        int surfaceDepth = -1;
        for (int y = startHeight; y >= minSurfaceHeight; --y) {
            BlockState stateAt = context.getBlockState(y);
            if (stateAt.isAir()) {
                surfaceDepth = -1;
                continue;
            }
            if (!context.isDefaultBlock(stateAt)) continue;
            if (surfaceDepth == -1) {
                if (y < context.getSeaLevel() - 1) {
                    context.setBlockState(y, SurfaceStates.SAND);
                    continue;
                }
                context.setBlockState(y, this.sampleLayer(this.getKarstOrVolcanicSandLayer(this.sandLayers0, karst, volcanic), this.getKarstOrVolcanicSandLayer(this.sandLayers1, karst, volcanic), y + height, style));
                surfaceDepth = 3;
                continue;
            }
            if (surfaceDepth <= 0) continue;
            --surfaceDepth;
            context.setBlockState(y, this.sampleLayer(this.getKarstOrVolcanicSandstoneLayer(this.sandstoneLayers0, karst, volcanic), this.getKarstOrVolcanicSandstoneLayer(this.sandstoneLayers1, karst, volcanic), y + height, style));
        }
    }

    private void buildSandStoneSurface(SurfaceBuilderContext context, int startHeight, int minSurfaceHeight, boolean karst, boolean volcanic, int sandstoneBaseHeight) {
        float style = (float)this.sandStyleNoise.noise(context.pos().getX(), context.pos().getZ());
        int height = (int)this.sandHeightOffsetNoise.noise(context.pos().getX(), context.pos().getZ());
        int surfaceDepth = -1;
        int sandstoneDepth = startHeight - sandstoneBaseHeight;
        for (int y = startHeight; y >= minSurfaceHeight; --y) {
            BlockState stateAt = context.getBlockState(y);
            if (stateAt.isAir()) {
                surfaceDepth = -1;
                continue;
            }
            if (!context.isDefaultBlock(stateAt)) continue;
            if (surfaceDepth == -1) {
                if (y < context.getSeaLevel() - 1) {
                    context.setBlockState(y, SurfaceStates.SAND);
                    continue;
                }
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(y, this.soilMinDepth);
                if (surfaceDepth < 0) {
                    if (sandstoneDepth > 0) {
                        context.setBlockState(y, this.sampleLayer(this.getKarstOrVolcanicSandstoneLayer(this.sandstoneLayers0, karst, volcanic), this.getKarstOrVolcanicSandstoneLayer(this.sandstoneLayers1, karst, volcanic), y + height, style));
                    }
                    surfaceDepth = 0;
                    continue;
                }
                context.setBlockState(y, SurfaceStates.TOP_GRASS_TO_SAND);
                sandstoneDepth -= surfaceDepth;
                continue;
            }
            if (surfaceDepth > 0) {
                --surfaceDepth;
                context.setBlockState(y, SurfaceStates.MID_DIRT_TO_SAND);
                continue;
            }
            if (sandstoneDepth <= 0) continue;
            --sandstoneDepth;
            context.setBlockState(y, this.sampleLayer(this.getKarstOrVolcanicSandstoneLayer(this.sandstoneLayers0, karst, volcanic), this.getKarstOrVolcanicSandstoneLayer(this.sandstoneLayers1, karst, volcanic), y + height, style));
        }
    }

    private BlockState sampleLayer(BlockState[] layers0, BlockState[] layers1, int y, float threshold) {
        int height = this.dippingStrata ? y / 4 : y;
        int index = Math.floorMod(height, 16);
        return (this.layerThresholds[index] < threshold ? layers0 : layers1)[index];
    }
}

