/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class BurrenSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = BurrenSurfaceBuilder::new;
    private final Noise2D crevices;

    public BurrenSurfaceBuilder(Seed seed) {
        this.crevices = BiomeNoise.burrenCrevices(seed.seed());
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        if (this.crevices.noise(context.pos().getX(), context.pos().getZ()) + 0.3 * context.weight() <= 0.4) {
            NormalSurfaceBuilder.ROCKY.buildSurface(context, startY, endY, SurfaceStates.TOP_GRASS_TO_GRAVEL, SurfaceStates.RAW, SurfaceStates.RAW);
        } else {
            NormalSurfaceBuilder.ROCKY.buildSurface(context, startY, endY, SurfaceStates.SNOWY_RAW, SurfaceStates.RAW, SurfaceStates.RAW);
        }
    }
}

