/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class GrassyDunesSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = GrassyDunesSurfaceBuilder::new;
    private final Noise2D grassHeightVariationNoise;

    public GrassyDunesSurfaceBuilder(Seed seed) {
        this.grassHeightVariationNoise = new OpenSimplex2D(seed.next()).octaves(2).scaled(71.0, 77.0).spread(0.08f);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        double heightVariation = this.grassHeightVariationNoise.noise(context.pos().getX(), context.pos().getZ());
        double trueSlope = context.getSlope();
        context.setSlope(trueSlope * (1.0 - context.weight()));
        if ((double)startY > heightVariation && trueSlope < 5.0) {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.TOP_GRASS_TO_SAND, SurfaceStates.SAND, SurfaceStates.SAND, SurfaceStates.SAND, SurfaceStates.SAND);
        } else {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.SNOWY_SAND, SurfaceStates.SAND, SurfaceStates.SAND, SurfaceStates.SAND, SurfaceStates.SAND);
        }
    }
}

