/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.ShieldVolcanoSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.ShoreAndOceanSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.world.level.block.state.BlockState;

public class IceSheetShieldVolcanoSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory ICE_SHEET = seed -> new IceSheetShieldVolcanoSurfaceBuilder(seed, BiomeNoise.glaciatedShieldVolcano(seed.seed(), BiomeNoise.hotSpotIntensity(seed.seed())), BiomeNoise.iceSheetSurfaceHeight(seed.seed()).max(BiomeNoise.shieldVolcanoIceSheetSurface(seed.seed(), BiomeNoise.hotSpotIntensity(seed.seed()))), false, true, 63);
    public static final SurfaceBuilderFactory GLACIATED = seed -> new IceSheetShieldVolcanoSurfaceBuilder(seed, BiomeNoise.glaciatedShieldVolcano(seed.seed(), BiomeNoise.hotSpotIntensity(seed.seed())), BiomeNoise.iceSheetSurfaceHeight(seed.seed()).max(BiomeNoise.shieldVolcanoGlacierSurface(seed.seed(), BiomeNoise.hotSpotIntensity(seed.seed()))), false, true, 93);
    private final Seed seed;
    private final Noise2D iceSurfaceNoise;
    private final Noise2D baseNoise;
    private final boolean hasMoraines;
    private final boolean hasStonyPeaks;
    private final int minFreezingHeight;
    private final SurfaceBuilder baseVolcanoSurfaceBuilder;

    IceSheetShieldVolcanoSurfaceBuilder(Seed seed, Noise2D baseNoise, Noise2D iceSurfaceNoise, boolean hasMoraines, boolean hasStonyPeaks, int minFreezingHeight) {
        this.seed = seed;
        this.baseNoise = baseNoise;
        this.iceSurfaceNoise = iceSurfaceNoise;
        this.hasMoraines = hasMoraines;
        this.hasStonyPeaks = hasStonyPeaks;
        this.minFreezingHeight = minFreezingHeight;
        this.baseVolcanoSurfaceBuilder = ShieldVolcanoSurfaceBuilder.DORMANT.apply(seed);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        int iceDepth;
        int x = context.pos().getX();
        int z = context.pos().getZ();
        int glacierBaseHeight = (int)Math.ceil(this.baseNoise.noise(x, z));
        int glacierSurfaceHeight = (int)Math.ceil(this.iceSurfaceNoise.noise(x, z));
        if (this.hasMoraines && context.baseGroundwater() <= 20.0f) {
            double moraineCrestHeight = Math.min(0.5 * (double)(glacierSurfaceHeight + glacierBaseHeight), (double)(glacierBaseHeight + 18));
            iceDepth = Math.max((int)(((double)startY - moraineCrestHeight) * 2.0), 0);
        } else {
            iceDepth = 35;
        }
        int seaLevel = context.getSeaLevel();
        if (startY <= seaLevel) {
            ShoreAndOceanSurfaceBuilder.OLD_SHIELD_VOLCANO.apply(this.seed).buildSurface(context, startY, endY);
        } else if (startY < this.minFreezingHeight || this.hasStonyPeaks && (double)startY > (double)glacierSurfaceHeight + 2.5 || (double)startY < (double)glacierBaseHeight - 1.5) {
            this.baseVolcanoSurfaceBuilder.buildSurface(context, startY, endY);
        } else {
            int surfaceDepth = -1;
            int surfaceY = 0;
            SurfaceState snowState = SurfaceStates.SNOW;
            SurfaceState iceState = SurfaceStates.PACKED_ICE;
            SurfaceState blueIceState = SurfaceStates.BLUE_ICE;
            SurfaceState moraineTopState = SurfaceStates.SNOWY_BASALT_MORAINE;
            SurfaceState moraineState = SurfaceStates.BASALT_MORAINE;
            SurfaceState basaltState = SurfaceStates.BASALT;
            for (int y = startY; y >= glacierBaseHeight - 22; --y) {
                BlockState stateAt = context.getBlockState(y);
                if (stateAt.isAir()) {
                    surfaceDepth = -1;
                    continue;
                }
                if (!context.isDefaultBlock(stateAt)) continue;
                if (surfaceDepth == -1) {
                    surfaceY = y;
                    surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, -3);
                    if (surfaceDepth <= -1) {
                        if (iceDepth < 1) {
                            context.setBlockState(y, moraineState);
                        } else if (y <= glacierBaseHeight) {
                            iceDepth = 0;
                        } else {
                            context.setBlockState(y, iceState);
                        }
                    } else if (iceDepth == 0 || y <= seaLevel || y < glacierBaseHeight) {
                        context.setBlockState(y, moraineState);
                    } else {
                        context.setBlockState(y, snowState);
                    }
                    surfaceDepth = 1;
                    continue;
                }
                if (iceDepth > 0 && y > glacierBaseHeight) {
                    --iceDepth;
                    context.setBlockState(y, y < glacierSurfaceHeight - 16 ? blueIceState : iceState);
                    continue;
                }
                if (y > glacierBaseHeight) {
                    context.setBlockState(y, y == startY ? moraineTopState : moraineState);
                    continue;
                }
                context.setBlockState(y, basaltState);
            }
        }
    }
}

