/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class LowlandsSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = LowlandsSurfaceBuilder::new;
    private final Noise2D surfaceMaterialNoise;

    public LowlandsSurfaceBuilder(Seed seed) {
        this.surfaceMaterialNoise = new OpenSimplex2D(seed.next()).octaves(2).spread(0.04f);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        float noise = (float)this.surfaceMaterialNoise.noise(context.pos().getX(), context.pos().getZ()) * 0.9f + context.random().nextFloat() * 0.1f;
        SurfaceState mud = context.groundWater() < 130.0f ? SurfaceStates.DRY_MUD : SurfaceStates.MUD;
        NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, noise < 0.0f ? SurfaceStates.TOP_GRASS_TO_GRAVEL : mud, mud, SurfaceStates.MID_DIRT_TO_GRAVEL, noise > 0.0f ? SurfaceStates.MID_DIRT_TO_GRAVEL : mud, mud);
    }
}

