/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.world.level.block.state.BlockState;

public enum NormalSurfaceBuilder implements SurfaceBuilderFactory.Invariant
{
    INSTANCE(-1),
    ROCKY(-3);

    private final int subsurfaceMinDepth;

    private NormalSurfaceBuilder(int subsurfaceMinDepth) {
        this.subsurfaceMinDepth = subsurfaceMinDepth;
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        this.buildSurface(context, startY, endY, SurfaceStates.TOP_GRASS_TO_GRAVEL, SurfaceStates.MID_DIRT_TO_GRAVEL, SurfaceStates.UNDER_GRAVEL);
    }

    public void buildSurface(SurfaceBuilderContext context, int startY, int endY, SurfaceState topCaveState, SurfaceState midCaveState, SurfaceState underCaveState, int caveHeight) {
        this.buildSurface(context, startY, endY, SurfaceStates.TOP_GRASS_TO_GRAVEL, SurfaceStates.MID_DIRT_TO_GRAVEL, SurfaceStates.UNDER_GRAVEL, SurfaceStates.GRAVEL, SurfaceStates.GRAVEL, topCaveState, midCaveState, underCaveState, caveHeight);
    }

    public void buildSurface(SurfaceBuilderContext context, int startY, int endY, SurfaceState topState, SurfaceState midState, SurfaceState underState) {
        this.buildSurface(context, startY, endY, topState, midState, underState, SurfaceStates.GRAVEL, SurfaceStates.GRAVEL);
    }

    public void buildSurface(SurfaceBuilderContext context, int startY, int endY, SurfaceState topState, SurfaceState midState, SurfaceState underState, SurfaceState underWaterState, SurfaceState thinUnderWaterState) {
        this.buildSurface(context, startY, endY, topState, midState, underState, underWaterState, thinUnderWaterState, topState, midState, underState, 63);
    }

    public void buildSurface(SurfaceBuilderContext context, int startY, int endY, SurfaceState topState, SurfaceState midState, SurfaceState underState, SurfaceState underWaterState, SurfaceState thinUnderWaterState, SurfaceState topCaveState, SurfaceState midCaveState, SurfaceState underCaveState, int caveHeight) {
        int surfaceDepth = -1;
        int surfaceY = 0;
        boolean underwaterLayer = false;
        boolean firstLayer = false;
        boolean hasPlacedFirstSurface = false;
        SurfaceState surfaceState = SurfaceStates.RAW;
        for (int y = startY; y >= endY; --y) {
            BlockState stateAt = context.getBlockState(y);
            if (stateAt.isAir()) {
                surfaceDepth = -1;
                if (y <= caveHeight) {
                    topState = topCaveState;
                    midState = midCaveState;
                    underState = underCaveState;
                    continue;
                }
                if (!hasPlacedFirstSurface) continue;
                topState = surfaceState;
                midState = surfaceState;
                underState = surfaceState;
                continue;
            }
            if (!context.isDefaultBlock(stateAt)) continue;
            if (surfaceDepth == -1) {
                surfaceY = y;
                firstLayer = true;
                if (y < context.getSeaLevel() - 1) {
                    surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, -1);
                    if (surfaceDepth < -1) {
                        surfaceDepth = 0;
                    } else if (surfaceDepth == -1) {
                        surfaceDepth = 0;
                        context.setBlockState(y, thinUnderWaterState);
                    } else {
                        context.setBlockState(y, underWaterState);
                    }
                    surfaceState = underWaterState;
                    underwaterLayer = true;
                    continue;
                }
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, this.subsurfaceMinDepth);
                if (surfaceDepth < -1) {
                    surfaceDepth = 0;
                } else if (surfaceDepth == -1) {
                    surfaceDepth = 0;
                    context.setBlockState(y, underState);
                } else {
                    context.setBlockState(y, topState);
                }
                surfaceState = midState;
                underwaterLayer = false;
                continue;
            }
            if (surfaceDepth <= 0) continue;
            hasPlacedFirstSurface = true;
            context.setBlockState(y, surfaceState);
            if (--surfaceDepth != 0 || !firstLayer) continue;
            firstLayer = false;
            if (underwaterLayer) {
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, 0);
                surfaceState = thinUnderWaterState;
                continue;
            }
            surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, 0);
            surfaceState = underState;
        }
    }
}

