/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class RockyPlateauSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = seed -> new RockyPlateauSurfaceBuilder(seed);
    private final long seed;

    public RockyPlateauSurfaceBuilder(Seed seed) {
        this.seed = seed.seed();
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        double weight = context.weight();
        NormalSurfaceBuilder surfaceBuilder = NormalSurfaceBuilder.ROCKY;
        if (weight > 0.9 && startY < 86 && context.baseGroundwater() == 0.0f) {
            surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.SALTED_EARTH, SurfaceStates.DRY_MUD, SurfaceStates.RAW);
        } else if ((double)(startY - 2) > BiomeNoise.hills(this.seed, 22, 32).noise(context.pos().getX(), context.pos().getZ())) {
            surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.RAW, SurfaceStates.RAW, SurfaceStates.RAW);
        } else {
            surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.TOP_GRASS_TO_SAND, SurfaceStates.MID_DIRT_TO_SAND, SurfaceStates.RAW);
        }
    }
}

