/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.world.level.block.state.BlockState;

public class ShieldVolcanoSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory ACTIVE = seed -> new ShieldVolcanoSurfaceBuilder(seed, true, false);
    public static final SurfaceBuilderFactory DORMANT = seed -> new ShieldVolcanoSurfaceBuilder(seed, false, false);
    public static final SurfaceBuilderFactory SHORE = seed -> new ShieldVolcanoSurfaceBuilder(seed, false, true);
    private final boolean hasLavaFlows;
    private final boolean isSandy;
    private final long seed;

    ShieldVolcanoSurfaceBuilder(Seed seed, boolean hasLavaFlows, boolean isSandy) {
        this.hasLavaFlows = hasLavaFlows;
        this.isSandy = isSandy;
        this.seed = seed.seed();
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        SurfaceState underwater;
        SurfaceState bot;
        SurfaceState mid;
        SurfaceState top;
        int x = context.pos().getX();
        int z = context.pos().getZ();
        if (this.isSandy) {
            top = SurfaceStates.VOLCANIC_SHORE_SAND;
            mid = SurfaceStates.VOLCANIC_SHORE_SAND;
            bot = SurfaceStates.VOLCANIC_SHORE_SANDSTONE;
            underwater = SurfaceStates.VOLCANIC_SHORE_SAND;
        } else {
            top = SurfaceStates.VOLCANIC_TOP_GRASS_TO_GRAVEL;
            mid = SurfaceStates.VOLCANIC_MID_DIRT_TO_GRAVEL;
            bot = SurfaceStates.BASALT_GRAVEL;
            underwater = SurfaceStates.BASALT_GRAVEL;
        }
        if (!this.hasLavaFlows) {
            this.buildSurface(context, startY, endY, top, mid, bot, underwater);
        } else {
            Noise2D smoothNoise = BiomeNoise.lavaFlowMaterial(this.seed);
            double noiseValue = smoothNoise.noise(x, z);
            Noise2D lavaFlows = BiomeNoise.lavaFlow(this.seed);
            double flowValue = lavaFlows.noise(x, z);
            if (flowValue < 0.4) {
                this.buildSurface(context, startY, endY, top, mid, bot, underwater);
            } else if (flowValue < 0.5) {
                if (noiseValue > 0.0) {
                    this.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT_GRAVEL, SurfaceStates.BASALT_GRAVEL, SurfaceStates.BASALT, SurfaceStates.BASALT_GRAVEL);
                } else {
                    this.buildSurface(context, startY, endY, top, mid, bot, underwater);
                }
            } else if (flowValue < 0.75) {
                if (noiseValue > 0.0) {
                    this.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT_GRAVEL, SurfaceStates.BASALT_GRAVEL, SurfaceStates.BASALT, SurfaceStates.BASALT_GRAVEL);
                } else {
                    this.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT_COBBLE, SurfaceStates.BASALT_COBBLE, SurfaceStates.BASALT, SurfaceStates.BASALT_COBBLE);
                }
            } else if (noiseValue > -0.6) {
                this.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT, SurfaceStates.BASALT, SurfaceStates.BASALT, SurfaceStates.BASALT_COBBLE);
            } else {
                this.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT_COBBLE, SurfaceStates.BASALT_COBBLE, SurfaceStates.BASALT, SurfaceStates.BASALT_COBBLE);
            }
        }
    }

    public void buildSurface(SurfaceBuilderContext context, int startY, int endY, SurfaceState topState, SurfaceState midState, SurfaceState underState, SurfaceState underWaterState) {
        int surfaceDepth = -1;
        int surfaceY = 0;
        boolean underwaterLayer = false;
        boolean firstLayer = false;
        SurfaceState surfaceState = SurfaceStates.BASALT;
        int basaltDepth = (int)(20.0 * context.weight());
        for (int y = startY; y >= endY; --y) {
            BlockState stateAt = context.getBlockState(y);
            if (stateAt.isAir()) {
                surfaceDepth = -1;
                continue;
            }
            if (!context.isDefaultBlock(stateAt)) continue;
            if (surfaceDepth == -1) {
                surfaceY = y;
                firstLayer = true;
                if (y < context.getSeaLevel() - 1) {
                    surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, -1);
                    if (surfaceDepth < -1) {
                        surfaceDepth = 0;
                        context.setBlockState(y, SurfaceStates.BASALT);
                    } else if (surfaceDepth == -1) {
                        surfaceDepth = 0;
                        context.setBlockState(y, underWaterState);
                    } else {
                        context.setBlockState(y, underWaterState);
                    }
                    surfaceState = underWaterState;
                    underwaterLayer = true;
                    continue;
                }
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, -3);
                if (surfaceDepth < -1) {
                    context.setBlockState(y, SurfaceStates.BASALT);
                    surfaceDepth = 0;
                } else if (surfaceDepth == -1) {
                    surfaceDepth = 0;
                    context.setBlockState(y, underState);
                } else {
                    context.setBlockState(y, topState);
                }
                surfaceState = midState;
                underwaterLayer = false;
                continue;
            }
            if (surfaceDepth > 0) {
                context.setBlockState(y, surfaceState);
                if (--surfaceDepth != 0 || !firstLayer) continue;
                firstLayer = false;
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, 0);
                if (!underwaterLayer) continue;
                surfaceState = underState;
                continue;
            }
            if (basaltDepth <= 0) continue;
            context.setBlockState(y, SurfaceStates.BASALT);
            --basaltDepth;
        }
    }
}

