/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.TuffRingNoise;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.world.level.block.state.BlockState;

public class TuffRingsSurfaceBuilder
implements SurfaceBuilder {
    private final SurfaceBuilder parent;
    private final TuffRingNoise tuffRingNoise;

    public static SurfaceBuilderFactory create(SurfaceBuilderFactory parent) {
        return seed -> new TuffRingsSurfaceBuilder(parent.apply(seed), seed);
    }

    public TuffRingsSurfaceBuilder(SurfaceBuilder parent, Seed seed) {
        this.parent = parent;
        this.tuffRingNoise = new TuffRingNoise(seed);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        float easing;
        if (context.biome().hasTuffRings() && (easing = this.tuffRingNoise.calculateEasing(context.pos().getX(), context.pos().getZ(), context.biome().getTuffRingRarity())) > 0.6f) {
            if (startY < context.getSeaLevel() + 3) {
                this.buildTuffSurface(context, startY, endY, SurfaceStates.VOLCANIC_SHORE_SAND, SurfaceStates.VOLCANIC_SHORE_SAND, SurfaceStates.TUFF, SurfaceStates.TUFF_GRAVEL);
            } else {
                this.buildTuffSurface(context, startY, endY, SurfaceStates.VOLCANIC_TOP_GRASS_TO_LOCAL_GRAVEL, SurfaceStates.VOLCANIC_MID_DIRT_TO_LOCAL_GRAVEL, SurfaceStates.TUFF, SurfaceStates.TUFF_GRAVEL);
            }
            return;
        }
        this.parent.buildSurface(context, startY, endY);
    }

    private void buildTuffSurface(SurfaceBuilderContext context, int startY, int endY, SurfaceState topState, SurfaceState midState, SurfaceState underState, SurfaceState underWaterState) {
        int surfaceDepth = -1;
        int surfaceY = 0;
        boolean underwaterLayer = false;
        boolean firstLayer = false;
        SurfaceState surfaceState = underState;
        int tuffDepth = (int)(20.0 * context.weight());
        for (int y = startY; y >= endY; --y) {
            BlockState stateAt = context.getBlockState(y);
            if (stateAt.isAir()) {
                surfaceDepth = -1;
                continue;
            }
            if (!context.isDefaultBlock(stateAt)) continue;
            if (surfaceDepth == -1) {
                surfaceY = y;
                firstLayer = true;
                if (y < context.getSeaLevel() - 1) {
                    surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, -1);
                    if (surfaceDepth < -1) {
                        surfaceDepth = 0;
                        context.setBlockState(y, SurfaceStates.TUFF);
                    } else if (surfaceDepth == -1) {
                        surfaceDepth = 0;
                        context.setBlockState(y, underWaterState);
                    } else {
                        context.setBlockState(y, underWaterState);
                    }
                    surfaceState = underWaterState;
                    underwaterLayer = true;
                    continue;
                }
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, -3);
                if (surfaceDepth < -1) {
                    context.setBlockState(y, SurfaceStates.TUFF);
                    surfaceDepth = 0;
                } else if (surfaceDepth == -1) {
                    surfaceDepth = 0;
                    context.setBlockState(y, underState);
                } else {
                    context.setBlockState(y, topState);
                }
                surfaceState = midState;
                underwaterLayer = false;
                continue;
            }
            if (surfaceDepth > 0) {
                context.setBlockState(y, surfaceState);
                if (--surfaceDepth != 0 || !firstLayer) continue;
                firstLayer = false;
                if (underwaterLayer) {
                    surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, 0);
                    continue;
                }
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, 0);
                surfaceState = underState;
                continue;
            }
            if (tuffDepth <= 0) continue;
            context.setBlockState(y, SurfaceStates.TUFF);
            --tuffDepth;
        }
    }
}

