/*
 * Decompiled with CFR 0.152.
 */
package paulevs.vbe.block;

import net.minecraft.class_17;
import net.minecraft.class_252;
import net.minecraft.class_328;
import net.minecraft.class_416;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.impl.world.chunk.ChunkSection;
import paulevs.vbe.VBE;
import paulevs.vbe.block.VBEBlockProperties;

public class VBEBlockFixer {
    public static void fixChunkSection(ChunkSection section) {
        for (int i = 0; i < 4096; i = (int)((short)(i + 1))) {
            BlockState fixed;
            int meta;
            byte dx = (byte)(i & 0xF);
            byte dy = (byte)(i >> 4 & 0xF);
            byte dz = (byte)(i >> 8);
            BlockState state = section.getBlockState((int)dx, (int)dy, (int)dz);
            if (state.getBlock() instanceof class_252 && VBE.ENHANCED_DOORS.getValue().booleanValue()) {
                meta = section.getMeta((int)dx, (int)dy, (int)dz);
                fixed = VBEBlockFixer.fixDoor(state, meta);
                if (state == fixed) continue;
                section.setBlockState((int)dx, (int)dy, (int)dz, fixed);
                continue;
            }
            if (state.getBlock() instanceof class_416 && VBE.ENHANCED_STAIRS.getValue().booleanValue()) {
                meta = section.getMeta((int)dx, (int)dy, (int)dz);
                fixed = VBEBlockFixer.fixStairs(state, meta);
                if (state == fixed) continue;
                section.setBlockState((int)dx, (int)dy, (int)dz, fixed);
                continue;
            }
            if (!(state.getBlock() instanceof class_328) || !VBE.ENHANCED_TRAPDOORS.getValue().booleanValue() || state == (fixed = VBEBlockFixer.fixTrapdoor(state, meta = section.getMeta((int)dx, (int)dy, (int)dz)))) continue;
            section.setBlockState((int)dx, (int)dy, (int)dz, fixed);
        }
    }

    public static BlockState fixDoor(BlockState state, int meta) {
        if (!VBEBlockFixer.isVanillaDoor(state.getBlock())) {
            return state;
        }
        if (VBEBlockFixer.skipFix(state, meta)) {
            return state;
        }
        boolean bottom = meta < 8;
        boolean open = (meta & 4) == 0;
        Direction dir = Direction.fromHorizontal((int)(meta & 3)).getOpposite();
        return (BlockState)((BlockState)((BlockState)state.with(VBEBlockProperties.TOP_BOTTOM, (Comparable)((Object)(bottom ? VBEBlockProperties.TopBottom.BOTTOM : VBEBlockProperties.TopBottom.TOP)))).with((Property)Properties.HORIZONTAL_FACING, (Comparable)dir)).with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(open));
    }

    public static int getDoorMeta(BlockState state) {
        int meta = ((Direction)state.get((Property)Properties.HORIZONTAL_FACING)).getHorizontal() & 3;
        if (!((Boolean)state.get((Property)VBEBlockProperties.OPENED)).booleanValue()) {
            meta |= 4;
        }
        if (state.get(VBEBlockProperties.TOP_BOTTOM) == VBEBlockProperties.TopBottom.TOP) {
            meta |= 8;
        }
        return meta;
    }

    private static BlockState fixStairs(BlockState state, int meta) {
        if (VBEBlockFixer.skipFix(state, meta)) {
            return state;
        }
        Direction dir = switch (meta & 3) {
            case 0 -> Direction.SOUTH;
            case 2 -> Direction.WEST;
            case 3 -> Direction.EAST;
            default -> Direction.NORTH;
        };
        return (BlockState)state.with((Property)Properties.HORIZONTAL_FACING, (Comparable)dir);
    }

    private static BlockState fixTrapdoor(BlockState state, int meta) {
        if (VBEBlockFixer.skipFix(state, meta)) {
            return state;
        }
        Direction dir = switch (meta & 3) {
            case 1 -> Direction.EAST;
            case 2 -> Direction.SOUTH;
            case 3 -> Direction.NORTH;
            default -> Direction.WEST;
        };
        boolean open = (meta & 4) != 0;
        return (BlockState)((BlockState)state.with((Property)Properties.HORIZONTAL_FACING, (Comparable)dir)).with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(open));
    }

    private static boolean skipFix(BlockState state, int meta) {
        return meta == 0 || state != state.getBlock().getDefaultState();
    }

    public static boolean isVanillaDoor(class_17 block) {
        return block == class_17.field_1853 || block == class_17.field_1860;
    }
}

