/*
 * Decompiled with CFR 0.152.
 */
package paulevs.vbe.block;

import java.util.ArrayList;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_212;
import net.minecraft.class_25;
import net.minecraft.class_27;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_533;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.world.BlockStateView;
import paulevs.vbe.VBE;
import paulevs.vbe.block.VBEBlockProperties;
import paulevs.vbe.utils.CreativeUtil;
import paulevs.vbe.utils.LevelUtil;

public class VBEHalfSlabBlock
extends TemplateBlock {
    private final Function<Integer, Integer> textureGetter;
    private class_17 fullBlock;

    public VBEHalfSlabBlock(Identifier id, class_15 material) {
        super(id, material);
        this.setTranslationKey(id);
        this.textureGetter = side -> this.field_1914;
        VBEHalfSlabBlock.field_1942[this.field_1915] = true;
    }

    public VBEHalfSlabBlock(Identifier id, class_17 source) {
        super(id, source.field_1900);
        this.setTranslationKey(id);
        class_17.field_1943[this.field_1915] = class_17.field_1943[source.field_1915] / 2;
        this.method_1587(source.method_1595() * 0.5f);
        this.method_1580(source.field_1926);
        this.textureGetter = arg_0 -> ((class_17)source).method_1607(arg_0);
        VBEHalfSlabBlock.field_1942[this.field_1915] = true;
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{VBEBlockProperties.DIRECTION});
    }

    public void setFullBlock(class_17 fullBlock) {
        this.fullBlock = fullBlock;
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        Direction face;
        class_339 pos;
        class_18 level = context.getWorld();
        BlockState state = level.getBlockState((pos = context.getBlockPos()).offset(face = context.getSide().getOpposite()));
        if (state.getBlock() instanceof VBEHalfSlabBlock) {
            class_54 player;
            Direction facing = (Direction)state.get(VBEBlockProperties.DIRECTION);
            if (facing.getAxis() != face.getAxis() && (player = context.getPlayer()) != null && !player.method_1373()) {
                return (BlockState)this.getDefaultState().with(VBEBlockProperties.DIRECTION, (Comparable)facing);
            }
        } else if (!VBE.VERTICAL_SLABS.getValue().booleanValue()) {
            class_54 player = context.getPlayer();
            float dy = 0.0f;
            if (player != null) {
                class_27 hit = LevelUtil.raycast(player.field_1596, player);
                dy = (float)(hit.field_1988.field_1586 - Math.floor(hit.field_1988.field_1586));
            }
            return (BlockState)this.getDefaultState().with(VBEBlockProperties.DIRECTION, (Comparable)(dy > 0.5f ? Direction.UP : Direction.DOWN));
        }
        return (BlockState)this.getDefaultState().with(VBEBlockProperties.DIRECTION, (Comparable)face);
    }

    public void method_1616(class_14 view, int x, int y, int z) {
        float maxY;
        float maxX;
        float minZ;
        float minY;
        float minX;
        if (!(view instanceof BlockStateView)) {
            this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        BlockStateView bsView = (BlockStateView)view;
        BlockState state = bsView.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        Direction facing = (Direction)state.get(VBEBlockProperties.DIRECTION);
        int dx = facing.getOffsetX();
        int dy = facing.getOffsetY();
        int dz = facing.getOffsetZ();
        float f = dx == 0 ? 0.0f : (minX = dx > 0 ? 0.5f : 0.0f);
        float f2 = dy == 0 ? 0.0f : (minY = dy > 0 ? 0.5f : 0.0f);
        float f3 = dz == 0 ? 0.0f : (minZ = dz > 0 ? 0.5f : 0.0f);
        float f4 = dx == 0 ? 1.0f : (maxX = dx > 0 ? 1.0f : 0.5f);
        float f5 = dy == 0 ? 1.0f : (maxY = dy > 0 ? 1.0f : 0.5f);
        float maxZ = dz == 0 ? 1.0f : (dz > 0 ? 1.0f : 0.5f);
        this.method_1578(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void method_1562(class_18 level, int x, int y, int z, class_25 box, ArrayList list) {
        this.method_1616((class_14)level, x, y, z);
        super.method_1562(level, x, y, z, box, list);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean method_1623() {
        return false;
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1608(class_18 level, int x, int y, int z, class_54 player) {
        class_31 stack = player.method_502();
        if (stack == null) {
            return false;
        }
        class_124 item = stack.method_694();
        if (!(item instanceof class_533)) {
            return false;
        }
        class_533 blockItem = (class_533)item;
        if (blockItem.getBlock() != this) {
            return false;
        }
        BlockState state = level.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return false;
        }
        Direction facing = (Direction)state.get(VBEBlockProperties.DIRECTION);
        class_27 hit = LevelUtil.raycast(level, player);
        if (hit == null || hit.field_1983 != class_212.field_789) {
            return false;
        }
        double dx = hit.field_1988.field_1585 - (double)x;
        double dy = hit.field_1988.field_1586 - (double)y;
        double dz = hit.field_1988.field_1587 - (double)z;
        if (dx < 0.0 || dx > 1.0 || dy < 0.0 || dy > 1.0 || dz < 0.0 || dz > 1.0) {
            return false;
        }
        Direction.Axis axis = facing.getAxis();
        if (axis == Direction.Axis.X && Math.abs(dx - 0.5) > 1.0E-4) {
            return false;
        }
        if (axis == Direction.Axis.Y && Math.abs(dy - 0.5) > 1.0E-4) {
            return false;
        }
        if (axis == Direction.Axis.Z && Math.abs(dz - 0.5) > 1.0E-4) {
            return false;
        }
        BlockState fullBlock = this.fullBlock.getDefaultState();
        if (fullBlock.getProperties().contains(VBEBlockProperties.AXIS)) {
            fullBlock = (BlockState)fullBlock.with(VBEBlockProperties.AXIS, (Comparable)facing.getAxis());
        } else if (fullBlock.getProperties().contains(VBEBlockProperties.DIRECTION)) {
            fullBlock = (BlockState)fullBlock.with(VBEBlockProperties.DIRECTION, (Comparable)facing);
        }
        level.setBlockState(x, y, z, fullBlock);
        level.method_150((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.field_1926.method_1978(), 1.0f, 1.0f);
        level.method_246(x, y, z);
        if (!CreativeUtil.isCreative(player)) {
            --stack.field_751;
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_1618(class_14 view, int x, int y, int z, int side) {
        Direction selfDir;
        if (!(view instanceof BlockStateView)) {
            return super.method_1618(view, x, y, z, side);
        }
        BlockStateView bsView = (BlockStateView)view;
        Direction face = Direction.byId((int)side);
        BlockState selfState = bsView.getBlockState(x, y, z);
        if (selfState.getBlock() instanceof VBEHalfSlabBlock && (face == (selfDir = (Direction)selfState.get(VBEBlockProperties.DIRECTION)) || face == selfDir.getOpposite())) {
            return super.method_1618(view, x, y, z, side);
        }
        BlockState sideState = bsView.getBlockState(x - face.getOffsetX(), y - face.getOffsetY(), z - face.getOffsetZ());
        if (sideState.getBlock() instanceof VBEHalfSlabBlock && selfState.getBlock() instanceof VBEHalfSlabBlock) {
            Direction slab2 = (Direction)selfState.get(VBEBlockProperties.DIRECTION);
            Direction slab1 = (Direction)sideState.get(VBEBlockProperties.DIRECTION);
            return slab1 != slab2;
        }
        return super.method_1618(view, x, y, z, side);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_1605() {
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public int method_1607(int side) {
        return this.textureGetter.apply(side);
    }
}

