/*
 * Decompiled with CFR 0.152.
 */
package paulevs.vbe.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_126;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_217;
import net.minecraft.class_299;
import net.minecraft.class_307;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.BlockTemplate;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.world.BlockStateView;
import paulevs.vbe.block.VBEBlockProperties;
import paulevs.vbe.block.VBEBlockTags;
import paulevs.vbe.utils.FloodFillSearch;
import paulevs.vbe.utils.LevelUtil;

public class VBELeavesBlock
extends class_307
implements BlockTemplate {
    private static final Function<BlockState, BlockState> ACTIVATOR = state -> {
        if (state.getBlock() instanceof VBELeavesBlock) {
            return (BlockState)state.with((Property)VBEBlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return state;
    };
    private static final Function<BlockState, Boolean> LEAVES_FILTER = state -> state.isIn(VBEBlockTags.LEAVES);
    private static final Function<BlockState, Boolean> LOG_FILTER = state -> state.isIn(VBEBlockTags.LOGS);
    private static final Map<Integer, FloodFillSearch> SEARCH_CACHE = new HashMap<Integer, FloodFillSearch>();
    private final FloodFillSearch search;
    private final int maxDistance;

    public VBELeavesBlock(Identifier id) {
        this(id, class_15.field_987, 5);
    }

    public VBELeavesBlock(Identifier id, class_15 material, int maxDistance) {
        super(BlockTemplate.getNextId(), 0, material, false);
        BlockTemplate.onConstructor((class_17)this, (Identifier)id);
        this.setTranslationKey(id);
        this.method_1580(field_1931);
        this.method_1599();
        this.method_1591();
        this.maxDistance = maxDistance;
        this.search = SEARCH_CACHE.computeIfAbsent(maxDistance, FloodFillSearch::new);
        this.setDefaultState((BlockState)((BlockState)this.getDefaultState().with((Property)VBEBlockProperties.NATURAL, (Comparable)Boolean.valueOf(true))).with((Property)VBEBlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.method_1590(4);
        this.method_1584(true);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{VBEBlockProperties.NATURAL, VBEBlockProperties.ACTIVE});
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        return (BlockState)this.getDefaultState().with((Property)VBEBlockProperties.NATURAL, (Comparable)Boolean.valueOf(false));
    }

    public void method_1609(class_18 level, int x, int y, int z, int blockID) {
        this.checkLeaves(level, x, y, z, true);
    }

    public void method_1602(class_18 level, int x, int y, int z, Random random) {
        this.checkLeaves(level, x, y, z, false);
    }

    public void method_1628(class_18 level, class_54 player, int x, int y, int z, int meta) {
        class_31 item;
        if (!level.field_180 && (item = player.method_502()) != null && item.method_694() instanceof class_126) {
            if (this.field_1919) {
                player.method_488(class_217.field_808[this.field_1915], 1);
            }
            this.method_1581(level, x, y, z, new class_31((class_17)this));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_1618(class_14 view, int x, int y, int z, int side) {
        if (view instanceof BlockStateView) {
            BlockStateView blockStateView = (BlockStateView)view;
            BlockState state = blockStateView.getBlockState(x, y, z);
            if (state.getBlock() instanceof class_299 || !state.isOpaque()) {
                return true;
            }
            return super.method_1618(view, x, y, z, side);
        }
        return super.method_1618(view, x, y, z, side);
    }

    private void checkLeaves(class_18 level, int x, int y, int z, boolean force) {
        if (level.field_180) {
            return;
        }
        BlockState state = level.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        if (!((Boolean)state.get((Property)VBEBlockProperties.NATURAL)).booleanValue()) {
            return;
        }
        boolean active = (Boolean)state.get((Property)VBEBlockProperties.ACTIVE);
        if (!force && !active) {
            return;
        }
        LevelUtil.setBlockSilent(level, x, y, z, (BlockState)state.with((Property)VBEBlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
        int radius = this.search.search(level, x, y, z, LOG_FILTER, LEAVES_FILTER);
        if (radius > 0 && radius <= this.maxDistance) {
            return;
        }
        if (force && !active) {
            this.search.transform(level, x, y, z, LEAVES_FILTER, ACTIVATOR);
        }
        this.method_1592(level, x, y, z, 0);
        level.setBlockState(x, y, z, (BlockState)States.AIR.get());
        level.method_246(x, y, z);
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            int pz;
            int py;
            Direction side = Direction.byId((int)i);
            int px = x + side.getOffsetX();
            state = level.getBlockState(px, py = y + side.getOffsetY(), pz = z + side.getOffsetZ());
            if (!(state.getBlock() instanceof VBELeavesBlock)) continue;
            level.method_216(px, py, pz, state.getBlock().field_1915, 10 + level.field_214.nextInt(20));
        }
    }
}

