/*
 * Decompiled with CFR 0.152.
 */
package paulevs.vbe.mixin.common;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_110;
import net.minecraft.class_134;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_320;
import net.minecraft.class_339;
import net.minecraft.class_395;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BeforeBlockRemoved;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.world.BlockStateView;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import paulevs.vbe.VBE;
import paulevs.vbe.block.VBEBlockProperties;
import paulevs.vbe.utils.LevelUtil;

@Mixin(value={class_110.class})
public abstract class ChestBlockMixin
extends class_395
implements BeforeBlockRemoved {
    protected ChestBlockMixin(int id, class_15 material) {
        super(id, material);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        if (!VBE.ENHANCED_CHESTS.getValue().booleanValue()) {
            return;
        }
        try {
            builder.add(new Property[]{Properties.HORIZONTAL_FACING, VBEBlockProperties.CHEST_PART});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        if (!VBE.ENHANCED_CHESTS.getValue().booleanValue()) {
            return super.getPlacementState(context);
        }
        class_18 level = context.getWorld();
        class_339 pos = context.getBlockPos();
        class_54 player = context.getPlayer();
        Direction facing = Direction.fromRotation((double)(player == null ? 0.0 : (double)player.field_1606));
        BlockState chest = (BlockState)this.getDefaultState().with((Property)Properties.HORIZONTAL_FACING, (Comparable)facing);
        if (player != null && player.method_1373()) {
            return (BlockState)chest.with(VBEBlockProperties.CHEST_PART, (Comparable)((Object)VBEBlockProperties.ChestPart.SINGLE));
        }
        Direction side = facing.rotateCounterclockwise(Direction.Axis.Y);
        class_339 sidePos = pos.offset(side);
        BlockState sideState = level.getBlockState(sidePos);
        if (sideState.isOf((class_17)this) && sideState.get(VBEBlockProperties.CHEST_PART) == VBEBlockProperties.ChestPart.SINGLE && sideState.get((Property)Properties.HORIZONTAL_FACING) == facing) {
            sideState = (BlockState)sideState.with(VBEBlockProperties.CHEST_PART, (Comparable)((Object)VBEBlockProperties.ChestPart.LEFT));
            LevelUtil.setBlockSilent(level, sidePos.getX(), sidePos.getY(), sidePos.getZ(), sideState);
            return (BlockState)chest.with(VBEBlockProperties.CHEST_PART, (Comparable)((Object)VBEBlockProperties.ChestPart.RIGHT));
        }
        side = facing.rotateClockwise(Direction.Axis.Y);
        sidePos = pos.offset(side);
        sideState = level.getBlockState(sidePos);
        if (sideState.isOf((class_17)this) && sideState.get(VBEBlockProperties.CHEST_PART) == VBEBlockProperties.ChestPart.SINGLE && sideState.get((Property)Properties.HORIZONTAL_FACING) == facing) {
            sideState = (BlockState)sideState.with(VBEBlockProperties.CHEST_PART, (Comparable)((Object)VBEBlockProperties.ChestPart.RIGHT));
            LevelUtil.setBlockSilent(level, sidePos.getX(), sidePos.getY(), sidePos.getZ(), sideState);
            return (BlockState)chest.with(VBEBlockProperties.CHEST_PART, (Comparable)((Object)VBEBlockProperties.ChestPart.LEFT));
        }
        return (BlockState)chest.with(VBEBlockProperties.CHEST_PART, (Comparable)((Object)VBEBlockProperties.ChestPart.SINGLE));
    }

    public void beforeBlockRemoved(class_18 level, int x, int y, int z) {
        if (!VBE.ENHANCED_CHESTS.getValue().booleanValue()) {
            return;
        }
        BlockState state = level.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        VBEBlockProperties.ChestPart part = (VBEBlockProperties.ChestPart)((Object)state.get(VBEBlockProperties.CHEST_PART));
        if (part == VBEBlockProperties.ChestPart.SINGLE) {
            return;
        }
        Direction facing = (Direction)state.get((Property)Properties.HORIZONTAL_FACING);
        Direction side = part == VBEBlockProperties.ChestPart.RIGHT ? facing.rotateCounterclockwise(Direction.Axis.Y) : facing.rotateClockwise(Direction.Axis.Y);
        state = level.getBlockState(x += side.getOffsetX(), y += side.getOffsetY(), z += side.getOffsetZ());
        if (state.isOf((class_17)this)) {
            LevelUtil.setBlockSilent(level, x, y, z, (BlockState)state.with(VBEBlockProperties.CHEST_PART, (Comparable)((Object)VBEBlockProperties.ChestPart.SINGLE)));
        }
    }

    @Inject(method={"canPlaceAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_canPlaceAt(class_18 level, int x, int y, int z, CallbackInfoReturnable<Boolean> info) {
        if (!VBE.ENHANCED_CHESTS.getValue().booleanValue()) {
            return;
        }
        info.setReturnValue((Object)true);
    }

    @Inject(method={"canUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_canUse(class_18 level, int x, int y, int z, class_54 player, CallbackInfoReturnable<Boolean> info) {
        if (!VBE.ENHANCED_CHESTS.getValue().booleanValue()) {
            return;
        }
        info.setReturnValue((Object)true);
        if (level.field_180) {
            return;
        }
        class_134 inventory = (class_134)level.method_1777(x, y, z);
        BlockState state = level.getBlockState(x, y, z);
        VBEBlockProperties.ChestPart part = (VBEBlockProperties.ChestPart)((Object)state.get(VBEBlockProperties.CHEST_PART));
        if (part == VBEBlockProperties.ChestPart.SINGLE) {
            player.method_486(inventory);
            return;
        }
        Direction facing = (Direction)state.get((Property)Properties.HORIZONTAL_FACING);
        Direction side = part == VBEBlockProperties.ChestPart.RIGHT ? facing.rotateCounterclockwise(Direction.Axis.Y) : facing.rotateClockwise(Direction.Axis.Y);
        state = level.getBlockState(x += side.getOffsetX(), y += side.getOffsetY(), z += side.getOffsetZ());
        if (!state.isOf((class_17)this)) {
            player.method_486(inventory);
            return;
        }
        class_134 sideInventory = (class_134)level.method_1777(x, y, z);
        switch (part) {
            case LEFT: {
                inventory = new class_320("Large chest", inventory, sideInventory);
                break;
            }
            case RIGHT: {
                inventory = new class_320("Large chest", sideInventory, inventory);
            }
        }
        player.method_486(inventory);
    }

    @Inject(method={"getTexture(Lnet/minecraft/level/BlockView;IIII)I"}, at={@At(value="HEAD")}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    private void vbe_getTextureForSide(class_14 view, int x, int y, int z, int side, CallbackInfoReturnable<Integer> info) {
        if (!VBE.ENHANCED_CHESTS.getValue().booleanValue()) {
            return;
        }
        if (side < 2) {
            return;
        }
        if (!(view instanceof BlockStateView)) {
            return;
        }
        BlockStateView blockStateView = (BlockStateView)view;
        BlockState state = blockStateView.getBlockState(x, y, z);
        Direction facing = (Direction)state.get((Property)Properties.HORIZONTAL_FACING);
        if (facing.getId() != side && facing.getOpposite().getId() != side) {
            info.setReturnValue((Object)this.field_1914);
            return;
        }
        VBEBlockProperties.ChestPart part = (VBEBlockProperties.ChestPart)((Object)state.get(VBEBlockProperties.CHEST_PART));
        int offset = facing.getId() == side ? 0 : 1;
        switch (part) {
            case RIGHT: {
                offset = facing.getId() == side ? 31 : 16;
                break;
            }
            case LEFT: {
                offset = facing.getId() == side ? 32 : 15;
            }
        }
        info.setReturnValue((Object)(this.field_1914 + offset));
    }
}

