/*
 * Decompiled with CFR 0.152.
 */
package paulevs.vbe.mixin.common;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_252;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.world.BlockStateView;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import paulevs.vbe.VBE;
import paulevs.vbe.block.VBEBlockFixer;
import paulevs.vbe.block.VBEBlockProperties;
import paulevs.vbe.block.VBEBlockTags;
import paulevs.vbe.utils.LevelUtil;

@Mixin(value={class_252.class})
public abstract class DoorBlockMixin
extends class_17 {
    @Unique
    private static boolean vbe_stopUpdate;

    @Shadow
    public abstract boolean method_1567(class_18 var1, int var2, int var3, int var4);

    public DoorBlockMixin(int i, class_15 arg) {
        super(i, arg);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue() || this.field_1915 > 71) {
            return;
        }
        builder.add(new Property[]{Properties.HORIZONTAL_FACING, VBEBlockProperties.TOP_BOTTOM, VBEBlockProperties.OPENED, VBEBlockProperties.INVERTED});
    }

    public void method_1611(class_18 level, int x, int y, int z) {
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue() || !VBEBlockFixer.isVanillaDoor(this)) {
            return;
        }
        BlockState state1 = level.getBlockState(x, y, z);
        if (!state1.isOf((class_17)this)) {
            return;
        }
        int meta = level.method_1778(x, y, z);
        BlockState state2 = VBEBlockFixer.fixDoor(state1, meta);
        if (state2 != state1) {
            LevelUtil.setBlockSilent(level, x, y, z, state2);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vbe_onDoorInit(int id, class_15 material, CallbackInfo info) {
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue()) {
            return;
        }
        DoorBlockMixin.field_1942[this.field_1915] = true;
        DoorBlockMixin.field_1941[this.field_1915] = 0;
        if (this.field_1915 > 71) {
            return;
        }
        this.setDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getDefaultState().with((Property)Properties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).with(VBEBlockProperties.TOP_BOTTOM, (Comparable)((Object)VBEBlockProperties.TopBottom.BOTTOM))).with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(true))).with((Property)VBEBlockProperties.INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(method={"getRenderType"}, at={@At(value="HEAD")}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    private void vbe_getRenderType(CallbackInfoReturnable<Integer> info) {
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue()) {
            return;
        }
        if (!VBEBlockFixer.isVanillaDoor(this)) {
            return;
        }
        info.setReturnValue((Object)0);
    }

    @Inject(method={"canUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_canUse(class_18 level, int x, int y, int z, class_54 player, CallbackInfoReturnable<Boolean> info) {
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue() || !VBEBlockFixer.isVanillaDoor(this)) {
            return;
        }
        info.setReturnValue((Object)true);
        BlockState state = level.getBlockState(x, y, z);
        if (state.isIn(VBEBlockTags.REQUIRES_POWER)) {
            return;
        }
        if (!state.isOf((class_17)this)) {
            return;
        }
        VBEBlockProperties.TopBottom part = (VBEBlockProperties.TopBottom)((Object)state.get(VBEBlockProperties.TOP_BOTTOM));
        int py = part == VBEBlockProperties.TopBottom.TOP ? y - 1 : y + 1;
        int y1 = Math.min(y, py);
        int y2 = Math.max(y, py);
        boolean opened = (Boolean)state.get((Property)VBEBlockProperties.OPENED) == false;
        opened |= level.method_265(x, y1, z) || level.method_265(x, y2, z);
        opened |= this.vbe_hasConnectedPower(level, x, y1, z, state);
        state = (BlockState)state.with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(opened));
        if (level.getBlockState(x, y, z) == state) {
            return;
        }
        LevelUtil.setBlockSilent(level, x, y, z, state);
        state = level.getBlockState(x, py, z);
        if (state.isOf((class_17)this)) {
            BlockState state2 = (BlockState)state.with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(opened));
            LevelUtil.setBlockSilent(level, x, py, z, state2);
        }
        level.method_202(x, y1, z, x, y2, z);
        level.method_173(player, 1003, x, y, z, 0);
        state = level.getBlockState(x, y1, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        this.vbe_updateSideDoor(level, x, y1, z, state);
    }

    @Inject(method={"getTexture"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_fixTexture(int i, int j, CallbackInfoReturnable<Integer> info) {
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue()) {
            return;
        }
        if (!VBEBlockFixer.isVanillaDoor(this)) {
            return;
        }
        info.setReturnValue((Object)0);
    }

    @Inject(method={"onAdjacentBlockUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_onAdjacentBlockUpdate(class_18 level, int x, int y, int z, int blockID, CallbackInfo info) {
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue() || !VBEBlockFixer.isVanillaDoor(this)) {
            return;
        }
        info.cancel();
        BlockState state = level.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        int py = y;
        VBEBlockProperties.TopBottom part = (VBEBlockProperties.TopBottom)((Object)state.get(VBEBlockProperties.TOP_BOTTOM));
        switch (part) {
            case TOP: {
                py = y - 1;
                break;
            }
            case BOTTOM: {
                py = y + 1;
            }
        }
        int y1 = Math.min(y, py);
        int y2 = Math.max(y, py);
        BlockState stateConnected = level.getBlockState(x, py, z);
        if (!stateConnected.isOf((class_17)this)) {
            LevelUtil.setBlockForceUpdate(level, x, y1, z, (BlockState)States.AIR.get());
            LevelUtil.setBlockForceUpdate(level, x, y2, z, (BlockState)States.AIR.get());
            if (part == VBEBlockProperties.TopBottom.BOTTOM) {
                level.method_202(x, y1, z, x, y2, z);
            } else {
                level.method_202(x, y1, z, x, y2, z);
            }
            return;
        }
        if (part == VBEBlockProperties.TopBottom.BOTTOM && !this.method_1567(level, x, y, z)) {
            LevelUtil.setBlockForceUpdate(level, x, y1, z, (BlockState)States.AIR.get());
            LevelUtil.setBlockForceUpdate(level, x, y2, z, (BlockState)States.AIR.get());
            level.method_202(x, y1, z, x, y2, z);
            this.method_1592(level, x, y1, z, 0);
            return;
        }
        if (class_17.field_1937[blockID].method_1569()) {
            boolean opened;
            boolean bl = opened = level.method_265(x, y1, z) || level.method_265(x, y2, z);
            if ((opened |= this.vbe_hasConnectedPower(level, x, y, z, state)) != (Boolean)state.get((Property)VBEBlockProperties.OPENED)) {
                state = (BlockState)state.with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(opened));
                LevelUtil.setBlockForceUpdate(level, x, y, z, state);
                LevelUtil.setBlockForceUpdate(level, x, py, z, (BlockState)stateConnected.with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(opened)));
                level.method_202(x, y1, z, x, y2, z);
                level.method_173(null, 1003, x, y1, z, 0);
            }
        }
        this.vbe_updateSideDoor(level, x, y1, z, state);
    }

    @Inject(method={"canPlaceAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_canPlaceAt(class_18 level, int x, int y, int z, CallbackInfoReturnable<Boolean> info) {
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue() || !VBEBlockFixer.isVanillaDoor(this)) {
            return;
        }
        info.setReturnValue((Object)level.method_1780(x, y - 1, z));
    }

    @Inject(method={"updateBoundingBox"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_updateBoundingBox(class_14 view, int x, int y, int z, CallbackInfo info) {
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue() || !VBEBlockFixer.isVanillaDoor(this)) {
            return;
        }
        info.cancel();
        if (!(view instanceof BlockStateView)) {
            return;
        }
        BlockStateView level = (BlockStateView)view;
        BlockState state = level.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        VBEBlockProperties.TopBottom part = (VBEBlockProperties.TopBottom)((Object)state.get(VBEBlockProperties.TOP_BOTTOM));
        Direction d = (Direction)state.get((Property)Properties.HORIZONTAL_FACING);
        if (((Boolean)state.get((Property)VBEBlockProperties.OPENED)).booleanValue()) {
            d = (Boolean)state.get((Property)VBEBlockProperties.INVERTED) != false ? d.rotateCounterclockwise(Direction.Axis.Y) : d.rotateClockwise(Direction.Axis.Y);
        }
        float y1 = part == VBEBlockProperties.TopBottom.BOTTOM ? 0.0f : -1.0f;
        float y2 = part == VBEBlockProperties.TopBottom.BOTTOM ? 2.0f : 1.0f;
        float min = 0.1875f;
        float max = 1.0f - min;
        if (this != field_1853 && this != field_1860) {
            y1 = 0.0f;
            y2 = 1.0f;
        }
        switch (d.getAxis()) {
            case X: {
                this.method_1578(d.getOffsetX() < 0 ? 0.0f : max, y1, 0.0f, d.getOffsetX() < 0 ? min : 1.0f, y2, 1.0f);
                break;
            }
            case Z: {
                this.method_1578(0.0f, y1, d.getOffsetZ() < 0 ? 0.0f : max, 1.0f, y2, d.getOffsetZ() < 0 ? min : 1.0f);
            }
        }
    }

    @Inject(method={"getOutlineShape"}, at={@At(value="HEAD")}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    private void vbe_getOutlineShape(class_18 level, int x, int y, int z, CallbackInfoReturnable<class_25> info) {
        if (!VBE.ENHANCED_DOORS.getValue().booleanValue() || !VBEBlockFixer.isVanillaDoor(this)) {
            return;
        }
        info.cancel();
        BlockState state = level.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        VBEBlockProperties.TopBottom part = (VBEBlockProperties.TopBottom)((Object)state.get(VBEBlockProperties.TOP_BOTTOM));
        Direction d = (Direction)state.get((Property)Properties.HORIZONTAL_FACING);
        if (((Boolean)state.get((Property)VBEBlockProperties.OPENED)).booleanValue()) {
            d = (Boolean)state.get((Property)VBEBlockProperties.INVERTED) != false ? d.rotateCounterclockwise(Direction.Axis.Y) : d.rotateClockwise(Direction.Axis.Y);
        }
        float y1 = part == VBEBlockProperties.TopBottom.BOTTOM ? 0.0f : -1.0f;
        float y2 = part == VBEBlockProperties.TopBottom.BOTTOM ? 2.0f : 1.0f;
        float min = 0.1875f;
        float max = 1.0f - min;
        switch (d.getAxis()) {
            case X: {
                this.method_1578(d.getOffsetX() < 0 ? 0.0f : max, y1, 0.0f, d.getOffsetX() < 0 ? min : 1.0f, y2, 1.0f);
                break;
            }
            case Z: {
                this.method_1578(0.0f, y1, d.getOffsetZ() < 0 ? 0.0f : max, 1.0f, y2, d.getOffsetZ() < 0 ? min : 1.0f);
            }
        }
        info.setReturnValue((Object)super.method_1622(level, x, y, z));
    }

    @Unique
    private void vbe_updateSideDoor(class_18 level, int x, int y, int z, BlockState state) {
        boolean inverted = (Boolean)state.get((Property)VBEBlockProperties.INVERTED);
        Direction offset = (Direction)state.get((Property)Properties.HORIZONTAL_FACING);
        offset = inverted ? offset.rotateClockwise(Direction.Axis.Y) : offset.rotateCounterclockwise(Direction.Axis.Y);
        BlockState sideStateBottom = level.getBlockState(x += offset.getOffsetX(), y, z += offset.getOffsetZ());
        if (!sideStateBottom.isOf((class_17)this) || (Boolean)sideStateBottom.get((Property)VBEBlockProperties.INVERTED) == inverted) {
            return;
        }
        BlockState sideStateTop = level.getBlockState(x, y + 1, z);
        if (!sideStateTop.isOf((class_17)this)) {
            return;
        }
        boolean opened = (Boolean)state.get((Property)VBEBlockProperties.OPENED);
        if (opened != (Boolean)sideStateBottom.get((Property)VBEBlockProperties.OPENED) || opened != (Boolean)sideStateTop.get((Property)VBEBlockProperties.OPENED)) {
            BlockState state2 = (BlockState)sideStateBottom.with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(opened));
            LevelUtil.setBlockForceUpdate(level, x, y, z, state2);
            state2 = (BlockState)sideStateTop.with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(opened));
            LevelUtil.setBlockForceUpdate(level, x, y + 1, z, state2);
            level.method_202(x, y, z, x, y + 1, z);
            level.method_173(null, 1003, x, y, z, 0);
        }
    }

    @Unique
    private boolean vbe_hasConnectedPower(class_18 level, int x, int y, int z, BlockState state) {
        boolean inverted = (Boolean)state.get((Property)VBEBlockProperties.INVERTED);
        Direction offset = (Direction)state.get((Property)Properties.HORIZONTAL_FACING);
        offset = inverted ? offset.rotateClockwise(Direction.Axis.Y) : offset.rotateCounterclockwise(Direction.Axis.Y);
        return level.method_265(x += offset.getOffsetX(), y, z += offset.getOffsetZ()) || level.method_265(x, y + 1, z);
    }
}

