/*
 * Decompiled with CFR 0.152.
 */
package paulevs.vbe.mixin.common;

import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_27;
import net.minecraft.class_328;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.world.BlockStateView;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import paulevs.vbe.VBE;
import paulevs.vbe.block.VBEBlockProperties;
import paulevs.vbe.block.VBEBlockTags;
import paulevs.vbe.utils.LevelUtil;

@Mixin(value={class_328.class})
public class TrapdoorBlockMixin
extends class_17 {
    public TrapdoorBlockMixin(int id, class_15 material) {
        super(id, material);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        if (!VBE.ENHANCED_TRAPDOORS.getValue().booleanValue()) {
            return;
        }
        builder.add(new Property[]{Properties.HORIZONTAL_FACING, VBEBlockProperties.TOP_BOTTOM, VBEBlockProperties.OPENED});
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        if (!VBE.ENHANCED_TRAPDOORS.getValue().booleanValue()) {
            return super.getPlacementState(context);
        }
        Direction facing = context.getSide().getOpposite();
        class_54 player = context.getPlayer();
        if (facing.getAxis() == Direction.Axis.Y) {
            facing = Direction.fromRotation((double)(player == null ? 0.0 : (double)player.field_1606));
        }
        BlockState state = (BlockState)this.getDefaultState().with((Property)Properties.HORIZONTAL_FACING, (Comparable)facing);
        class_339 pos = context.getBlockPos();
        class_18 level = context.getWorld();
        boolean opened = level.method_265(pos.getX(), pos.getY(), pos.getZ());
        state = (BlockState)state.with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(opened));
        if (player != null) {
            class_27 hit = LevelUtil.raycast(level, player);
            float dy = (float)(hit.field_1988.field_1586 - Math.floor(hit.field_1988.field_1586));
            state = (BlockState)state.with(VBEBlockProperties.TOP_BOTTOM, (Comparable)((Object)(dy > 0.5f ? VBEBlockProperties.TopBottom.TOP : VBEBlockProperties.TopBottom.BOTTOM)));
        }
        return state;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vbe_onInit(int id, class_15 material, CallbackInfo info) {
        if (!VBE.ENHANCED_TRAPDOORS.getValue().booleanValue()) {
            return;
        }
        this.setDefaultState((BlockState)((BlockState)((BlockState)this.getDefaultState().with((Property)Properties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).with(VBEBlockProperties.TOP_BOTTOM, (Comparable)((Object)VBEBlockProperties.TopBottom.BOTTOM))).with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(method={"onAdjacentBlockUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_onAdjacentBlockUpdate(class_18 level, int x, int y, int z, int blockID, CallbackInfo info) {
        boolean opened;
        if (!VBE.ENHANCED_TRAPDOORS.getValue().booleanValue()) {
            return;
        }
        info.cancel();
        BlockState state = level.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        if (class_17.field_1937[blockID].method_1569() && (opened = level.method_265(x, y, z)) != (Boolean)state.get((Property)VBEBlockProperties.OPENED)) {
            state = (BlockState)state.with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(opened));
            LevelUtil.setBlockSilent(level, x, y, z, state);
            level.method_246(x, y, z);
            level.method_173(null, 1003, x, y, z, 0);
        }
    }

    @Inject(method={"canUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_canUse(class_18 level, int x, int y, int z, class_54 player, CallbackInfoReturnable<Boolean> info) {
        if (!VBE.ENHANCED_TRAPDOORS.getValue().booleanValue()) {
            return;
        }
        info.setReturnValue((Object)true);
        BlockState state = level.getBlockState(x, y, z);
        if (state.isIn(VBEBlockTags.REQUIRES_POWER)) {
            return;
        }
        if (!state.isOf((class_17)this)) {
            return;
        }
        boolean opened = (Boolean)state.get((Property)VBEBlockProperties.OPENED) == false || level.method_265(x, y, z);
        BlockState changed = (BlockState)state.with((Property)VBEBlockProperties.OPENED, (Comparable)Boolean.valueOf(opened));
        if (changed == state) {
            return;
        }
        LevelUtil.setBlockSilent(level, x, y, z, changed);
        level.method_246(x, y, z);
        level.method_173(null, 1003, x, y, z, 0);
    }

    @Inject(method={"updateBoundingBox"}, at={@At(value="HEAD")}, cancellable=true)
    public void vbe_updateBoundingBox(class_14 view, int x, int y, int z, CallbackInfo info) {
        if (!VBE.ENHANCED_TRAPDOORS.getValue().booleanValue()) {
            return;
        }
        info.cancel();
        if (!(view instanceof BlockStateView)) {
            return;
        }
        BlockStateView level = (BlockStateView)view;
        BlockState state = level.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        VBEBlockProperties.TopBottom part = (VBEBlockProperties.TopBottom)((Object)state.get(VBEBlockProperties.TOP_BOTTOM));
        float min = 0.1875f;
        float max = 1.0f - min;
        if (!((Boolean)state.get((Property)VBEBlockProperties.OPENED)).booleanValue()) {
            float y1 = part == VBEBlockProperties.TopBottom.BOTTOM ? 0.0f : max;
            float y2 = part == VBEBlockProperties.TopBottom.BOTTOM ? min : 1.0f;
            this.method_1578(0.0f, y1, 0.0f, 1.0f, y2, 1.0f);
            return;
        }
        Direction d = (Direction)state.get((Property)Properties.HORIZONTAL_FACING);
        switch (d.getAxis()) {
            case X: {
                this.method_1578(d.getOffsetX() < 0 ? 0.0f : max, 0.0f, 0.0f, d.getOffsetX() < 0 ? min : 1.0f, 1.0f, 1.0f);
                break;
            }
            case Z: {
                this.method_1578(0.0f, 0.0f, d.getOffsetZ() < 0 ? 0.0f : max, 1.0f, 1.0f, d.getOffsetZ() < 0 ? min : 1.0f);
            }
        }
    }

    @Inject(method={"canPlaceAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void vbe_canPlaceAt(class_18 level, int x, int y, int z, int side, CallbackInfoReturnable<Boolean> info) {
        if (!VBE.ENHANCED_TRAPDOORS.getValue().booleanValue()) {
            return;
        }
        info.setReturnValue((Object)true);
    }
}

