/*
 * Decompiled with CFR 0.152.
 */
package paulevs.vbe.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import paulevs.vbe.utils.ConfigEntry;

public class Config {
    private final Map<String, ConfigEntry<?>> entries = new HashMap();
    private final Map<String, String> preEntries = new HashMap<String, String>();
    private final List<String> order = new ArrayList<String>();
    private final File file;

    public Config(String name) {
        this.file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "vbe/" + name + ".cfg");
        if (this.file.exists()) {
            this.load();
        }
    }

    public void save() {
        if (!this.file.exists()) {
            this.writeFile();
        } else if (this.entries.size() != this.preEntries.size()) {
            this.writeFile();
        }
    }

    public ConfigEntry<Boolean> addEntry(String name, boolean value, String ... comments) {
        String stored = this.preEntries.get(name);
        if (stored != null) {
            value = Boolean.parseBoolean(stored);
        }
        ConfigEntry<Boolean> entry = new ConfigEntry<Boolean>(name, value, List.of(comments));
        this.entries.put(name, entry);
        this.order.add(name);
        return entry;
    }

    public ConfigEntry<Float> addEntry(String name, float value, String ... comments) {
        String stored = this.preEntries.get(name);
        if (stored != null) {
            value = Float.parseFloat(stored);
        }
        ConfigEntry<Float> entry = new ConfigEntry<Float>(name, Float.valueOf(value), List.of(comments));
        this.entries.put(name, entry);
        this.order.add(name);
        return entry;
    }

    public ConfigEntry<Integer> addEntry(String name, int value, String ... comments) {
        String stored = this.preEntries.get(name);
        if (stored != null) {
            value = Integer.parseInt(stored);
        }
        ConfigEntry<Integer> entry = new ConfigEntry<Integer>(name, value, List.of(comments));
        this.entries.put(name, entry);
        this.order.add(name);
        return entry;
    }

    public ConfigEntry<String> addEntry(String name, String value, String ... comments) {
        String stored = this.preEntries.get(name);
        if (stored != null) {
            value = stored;
        }
        ConfigEntry<String> entry = new ConfigEntry<String>(name, value, List.of(comments));
        this.entries.put(name, entry);
        this.order.add(name);
        return entry;
    }

    private void writeFile() {
        int max = this.entries.size() - 1;
        try {
            this.file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.file);
            for (int i = 0; i < this.order.size(); ++i) {
                this.entries.get(this.order.get(i)).append(writer);
                if (i >= max) continue;
                writer.append('\n');
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void load() {
        List<String> lines = null;
        try {
            lines = Files.readAllLines(this.file.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (lines == null) {
            return;
        }
        lines.stream().filter(line -> line.length() > 2 && line.charAt(0) != '#').forEach(line -> {
            int split = line.indexOf(61);
            String name = line.substring(0, split).trim();
            String value = line.substring(split + 1).trim();
            this.preEntries.put(name, value);
        });
    }
}

