/*
 * Decompiled with CFR 0.152.
 */
package paulevs.vbe.utils;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConfigEntry<T> {
    private final List<String> comments = new ArrayList<String>();
    private final String name;
    protected final T value;

    protected ConfigEntry(String name, T value, List<String> comments) {
        this.comments.addAll(comments);
        this.value = value;
        this.name = name;
    }

    protected void append(FileWriter writer) throws IOException {
        for (String comment : this.comments) {
            writer.append("# ");
            writer.append(comment);
            writer.append('\n');
        }
        writer.append(this.name);
        writer.append(" = ");
        writer.append(this.valueAsString());
        writer.append('\n');
    }

    private String valueAsString() {
        return String.valueOf(this.value);
    }

    public T getValue() {
        return this.value;
    }
}

