/*
 * Decompiled with CFR 0.152.
 */
package paulevs.vbe.utils;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.util.math.Direction;
import paulevs.vbe.utils.LevelUtil;

public class FloodFillSearch {
    private final List<IntList> buffers = new ArrayList<IntList>();
    private final boolean[] mask;
    private final short[] steps;
    private final int offset;
    private final int side;
    private final int side2;
    private final int center;

    public FloodFillSearch(int radius) {
        this.offset = radius;
        this.side = radius << 1 | 1;
        this.side2 = this.side * this.side;
        this.mask = new boolean[this.side * this.side2];
        this.steps = new short[this.mask.length];
        this.center = this.getIndex(this.offset, this.offset, this.offset);
        this.buffers.add((IntList)new IntArrayList(this.mask.length >> 2));
        this.buffers.add((IntList)new IntArrayList(this.mask.length >> 2));
    }

    public int search(class_18 level, int x, int y, int z, Function<BlockState, Boolean> criteria, Function<BlockState, Boolean> filter) {
        IntList starts = this.buffers.get(0);
        starts.clear();
        starts.add(this.center);
        Arrays.fill(this.mask, false);
        this.mask[this.center] = true;
        x -= this.offset;
        y -= this.offset;
        z -= this.offset;
        int index = 0;
        while (!starts.isEmpty()) {
            starts = this.buffers.get(index);
            index = (byte)(index + 1 & 1);
            IntList ends = this.buffers.get(index);
            ends.clear();
            IntListIterator intListIterator = starts.iterator();
            while (intListIterator.hasNext()) {
                int pos = (Integer)intListIterator.next();
                int dx = this.getX(pos);
                int dy = this.getY(pos);
                int dz = this.getZ(pos);
                for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                    int cellIndex;
                    int pz;
                    int py;
                    Direction side = Direction.byId((int)i);
                    int px = dx + side.getOffsetX();
                    if (!this.isInBound(px) || !this.isInBound(py = dy + side.getOffsetY()) || !this.isInBound(pz = dz + side.getOffsetZ()) || this.mask[cellIndex = this.getIndex(px, py, pz)]) continue;
                    BlockState state = level.getBlockState(x + px, y + py, z + pz);
                    if (criteria.apply(state).booleanValue()) {
                        return this.steps[pos] + 1;
                    }
                    if (!filter.apply(state).booleanValue()) {
                        this.mask[cellIndex] = true;
                        continue;
                    }
                    this.steps[cellIndex] = (short)(this.steps[pos] + 1);
                    this.mask[cellIndex] = true;
                    ends.add(cellIndex);
                }
            }
        }
        return -1;
    }

    public void transform(class_18 level, int x, int y, int z, Function<BlockState, Boolean> criteria, Function<BlockState, BlockState> transformer) {
        IntList starts = this.buffers.get(0);
        starts.clear();
        starts.add(this.center);
        Arrays.fill(this.mask, false);
        this.mask[this.center] = true;
        x -= this.offset;
        y -= this.offset;
        z -= this.offset;
        int index = 0;
        while (!starts.isEmpty()) {
            starts = this.buffers.get(index);
            index = (byte)(index + 1 & 1);
            IntList ends = this.buffers.get(index);
            ends.clear();
            IntListIterator intListIterator = starts.iterator();
            while (intListIterator.hasNext()) {
                int pos = (Integer)intListIterator.next();
                int dx = this.getX(pos);
                int dy = this.getY(pos);
                int dz = this.getZ(pos);
                for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                    int cellIndex;
                    int pz;
                    int py;
                    Direction side = Direction.byId((int)i);
                    int px = dx + side.getOffsetX();
                    if (!this.isInBound(px) || !this.isInBound(py = dy + side.getOffsetY()) || !this.isInBound(pz = dz + side.getOffsetZ()) || this.mask[cellIndex = this.getIndex(px, py, pz)]) continue;
                    BlockState state = level.getBlockState(x + px, y + py, z + pz);
                    if (criteria.apply(state).booleanValue()) {
                        BlockState transformed = transformer.apply(state);
                        if (transformed != state) {
                            LevelUtil.setBlockSilent(level, x + px, y + py, z + pz, transformed);
                        }
                        ends.add(cellIndex);
                    }
                    this.mask[cellIndex] = true;
                }
            }
        }
    }

    private boolean isInBound(int value) {
        return value >= 0 && value < this.side;
    }

    private int getIndex(int x, int y, int z) {
        return x * this.side2 + y * this.side + z;
    }

    private int getX(int pos) {
        return pos / this.side2;
    }

    private int getY(int pos) {
        return pos / this.side % this.side;
    }

    private int getZ(int pos) {
        return pos % this.side;
    }
}

