package com.koteinik.chunksfadein.crowdin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.NotNull;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public class Translations {
	private static Map<String, String> enUs;
	private static volatile Map<String, Map<String, String>> translations = new ConcurrentHashMap<>();

	static {
		try (InputStream inputStream = Translations.class
			.getClassLoader()
			.getResourceAsStream("assets/chunksfadein/lang/en_us.json")) {
			BufferedInputStream bis = new BufferedInputStream(Objects.requireNonNull(inputStream));
			enUs = parseJsonTranslations(new String(bis.readAllBytes()));
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	static void addTranslations(Map<String, Map<String, String>> newTranslations) {
		translations.putAll(newTranslations);
	}

	public static class_5250 translatable(String key) {
		return class_5250.method_43477(new class_7417() {
			@Override
			public @NotNull MapCodec<? extends class_7417> method_74063() {
				return class_8828.field_46623;
			}

			@Override
			public <T> @NotNull Optional<T> method_27659(class_5348.@NotNull class_5245<T> consumer) {
				return consumer.accept(Translations.resolve(key));
			}

			@Override
			public <T> @NotNull Optional<T> method_27660(class_5348.@NotNull class_5246<T> consumer, @NotNull class_2583 style) {
				return consumer.accept(style, Translations.resolve(key));
			}
		});
	}

	public static synchronized String resolve(String key) {
		String language = class_310.method_1551().field_1690.field_1883;

		Map<String, String> map = translations.get(language);
		if (map != null) {
			String value = map.get(key);
			if (value != null) return value;
		}

		return getDefault(key);
	}

	public static String getDefault(String key) {
		String value = enUs.get(key);
		if (value == null) return "null";
		return value;
	}

	public static void download() {
		new TranslationsDownloader().start();
	}

	static Map<String, String> parseJsonTranslations(String json) {
		JsonObject jsonPairs = JsonParser.parseString(json).getAsJsonObject();

		return jsonPairs.asMap().entrySet().stream()
			.map(e -> new AbstractMap.SimpleEntry<>(e.getKey(), e.getValue().getAsString()))
			.collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
	}
}
