/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.dh;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.core.GlStateSaver;
import com.koteinik.chunksfadein.core.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL21;
import org.lwjgl.system.MemoryUtil;

public class LodMaskTexture {
    private static LodMaskTexture instance = null;
    private static int lastLevel = 0;
    public final int id;
    public final int sizeX;
    public final int sizeY;
    public final int sizeZ;
    public final int minY;
    public final int maxY;
    public class_1923 origin;
    private final ByteBuffer textureDataBuffer;
    private final Set<class_4076> rendered;
    private boolean needUpdate = false;

    public static synchronized void createAndUpdate() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            return;
        }
        int minY = minecraft.field_1687.method_32891();
        int maxY = minecraft.field_1687.method_31597();
        int renderDistance = Utils.chunkRenderDistance();
        int sizeX = renderDistance * 2 + 1;
        int sizeY = maxY - minY + 1;
        int sizeZ = renderDistance * 2 + 1;
        if (sizeX <= 0 || sizeY <= 0 || sizeZ <= 0) {
            return;
        }
        class_243 cameraPos = Utils.cameraPosition();
        class_1923 origin = new class_1923((int)Math.floor(cameraPos.field_1352 / 16.0), (int)Math.floor(cameraPos.field_1350 / 16.0));
        try {
            if (instance == null) {
                instance = new LodMaskTexture(sizeX, sizeY, sizeZ, minY, maxY, origin, null);
            } else if (LodMaskTexture.instance.sizeX != sizeX || LodMaskTexture.instance.sizeY != sizeY || LodMaskTexture.instance.sizeZ != sizeZ || LodMaskTexture.instance.minY != minY || LodMaskTexture.instance.maxY != maxY) {
                instance.cleanup();
                instance = new LodMaskTexture(sizeX, sizeY, sizeZ, minY, maxY, origin, LodMaskTexture.instance.rendered);
            }
        }
        catch (Exception e) {
            Logger.error("Failed to create LodMaskTexture: ", e);
            instance = null;
        }
        int currentLevel = minecraft.field_1687.hashCode();
        if (lastLevel != currentLevel) {
            LodMaskTexture.instance.rendered.clear();
        }
        lastLevel = currentLevel;
        LodMaskTexture.instance.origin = origin;
        instance.update();
    }

    public static LodMaskTexture getInstance() {
        return instance;
    }

    public static int getId() {
        LodMaskTexture instance = LodMaskTexture.getInstance();
        if (instance == null) {
            return -1;
        }
        return instance.id;
    }

    public static void markRendered(int chunkX, int chunkY, int chunkZ) {
        if (instance != null) {
            instance.markRendered(class_4076.method_18676((int)chunkX, (int)chunkY, (int)chunkZ));
        }
    }

    public static void bind(int slot) {
        if (instance != null) {
            instance.bindTexture(slot);
        }
    }

    private LodMaskTexture(int sizeX, int sizeY, int sizeZ, int minY, int maxY, class_1923 origin, Set<class_4076> rendered) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.minY = minY;
        this.maxY = maxY;
        this.origin = origin;
        this.rendered = rendered == null ? ConcurrentHashMap.newKeySet(sizeX * sizeY * sizeZ) : rendered;
        this.textureDataBuffer = MemoryUtil.memAlloc((int)(sizeX * sizeY * sizeZ * 4));
        this.id = GL11.glGenTextures();
        GlStateSaver.withSavedState(() -> {
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)32879, (int)this.id);
            this.clearGlState();
            GL12.glTexImage3D((int)32879, (int)0, (int)32856, (int)sizeX, (int)sizeY, (int)sizeZ, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            GL11.glTexParameteri((int)32879, (int)10241, (int)9728);
            GL11.glTexParameteri((int)32879, (int)10240, (int)9728);
            GL11.glTexParameteri((int)32879, (int)10242, (int)33069);
            GL11.glTexParameteri((int)32879, (int)10243, (int)33069);
            GL11.glTexParameteri((int)32879, (int)32882, (int)33069);
            GL11.glTexParameterfv((int)32879, (int)4100, (float[])new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        });
    }

    public synchronized void update() {
        RenderSystem.assertOnRenderThread();
        int renderDistance = Utils.chunkRenderDistance();
        this.textureDataBuffer.clear();
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int x = 0; x < this.sizeX; ++x) {
                    int centerX = this.sizeX / 2;
                    int centerZ = this.sizeZ / 2;
                    boolean wasRendered = this.rendered.remove(class_4076.method_18676((int)(this.origin.field_9181 - centerX + x), (int)(this.minY + y), (int)(this.origin.field_9180 - centerZ + z)));
                    if (Math.floor(Math.sqrt(Math.pow(x - centerX, 2.0) + Math.pow(z - centerZ, 2.0))) >= (double)renderDistance) {
                        wasRendered = false;
                    }
                    byte val = (byte)(wasRendered ? 255 : 0);
                    this.needUpdate |= this.textureDataBuffer.get(this.textureDataBuffer.position()) != val;
                    this.textureDataBuffer.put(val);
                    this.textureDataBuffer.put((byte)0);
                    this.textureDataBuffer.put((byte)0);
                    this.textureDataBuffer.put((byte)0);
                }
            }
        }
        this.textureDataBuffer.flip();
        this.rendered.clear();
        if (!this.needUpdate) {
            return;
        }
        GlStateSaver.withSavedState(() -> {
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)32879, (int)this.id);
            this.clearGlState();
            GL12.glTexSubImage3D((int)32879, (int)0, (int)0, (int)0, (int)0, (int)this.sizeX, (int)this.sizeY, (int)this.sizeZ, (int)6408, (int)5121, (ByteBuffer)this.textureDataBuffer);
        });
        this.needUpdate = false;
    }

    public synchronized void markRendered(class_4076 pos) {
        this.rendered.add(pos);
    }

    public void bindTexture(int slot) {
        int prevActive = GL13.glGetInteger((int)34016);
        GL13.glActiveTexture((int)(33984 + slot));
        GL11.glBindTexture((int)32879, (int)this.id);
        GL13.glActiveTexture((int)prevActive);
    }

    public void cleanup() {
        if (this.id != -1) {
            GL11.glDeleteTextures((int)this.id);
        }
        if (this.textureDataBuffer != null) {
            MemoryUtil.memFree((Buffer)this.textureDataBuffer);
        }
    }

    private void clearGlState() {
        GL21.glBindBuffer((int)35052, (int)0);
        GL11.glPixelStorei((int)3317, (int)4);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glPixelStorei((int)32877, (int)0);
        GL11.glPixelStorei((int)32878, (int)0);
        GL11.glPixelStorei((int)3312, (int)0);
        GL11.glPixelStorei((int)3313, (int)0);
    }
}

