/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.crowdin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.koteinik.chunksfadein.crowdin.TranslationsDownloader;
import com.mojang.serialization.MapCodec;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import org.jetbrains.annotations.NotNull;

public class Translations {
    private static Map<String, String> enUs;
    private static volatile Map<String, Map<String, String>> translations;

    static void addTranslations(Map<String, Map<String, String>> newTranslations) {
        translations.putAll(newTranslations);
    }

    public static class_5250 translatable(final String key) {
        return class_5250.method_43477((class_7417)new class_7417(){

            @NotNull
            public MapCodec<? extends class_7417> method_74063() {
                return class_8828.field_46623;
            }

            @NotNull
            public <T> Optional<T> method_27659(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull class_5348.class_5245<T> consumer) {
                return consumer.accept(Translations.resolve(key));
            }

            @NotNull
            public <T> Optional<T> method_27660(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull class_5348.class_5246<T> consumer, @NotNull class_2583 style) {
                return consumer.accept(style, Translations.resolve(key));
            }
        });
    }

    public static synchronized String resolve(String key) {
        String value;
        String language = class_310.method_1551().field_1690.field_1883;
        Map<String, String> map = translations.get(language);
        if (map != null && (value = map.get(key)) != null) {
            return value;
        }
        return Translations.getDefault(key);
    }

    public static String getDefault(String key) {
        String value = enUs.get(key);
        if (value == null) {
            return "null";
        }
        return value;
    }

    public static void download() {
        new TranslationsDownloader().start();
    }

    static Map<String, String> parseJsonTranslations(String json) {
        JsonObject jsonPairs = JsonParser.parseString((String)json).getAsJsonObject();
        return jsonPairs.asMap().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), ((JsonElement)e.getValue()).getAsString())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    static {
        translations = new ConcurrentHashMap<String, Map<String, String>>();
        try (InputStream inputStream = Translations.class.getClassLoader().getResourceAsStream("assets/chunksfadein/lang/en_us.json");){
            BufferedInputStream bis = new BufferedInputStream(Objects.requireNonNull(inputStream));
            enUs = Translations.parseJsonTranslations(new String(bis.readAllBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

