/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.gui;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.ShaderUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.Curve;
import com.koteinik.chunksfadein.core.FadeType;
import com.koteinik.chunksfadein.core.FogOverrideMode;
import com.koteinik.chunksfadein.gui.GuiUtils;
import com.koteinik.chunksfadein.gui.components.CFIButton;
import com.koteinik.chunksfadein.gui.components.CFIListWidget;
import com.koteinik.chunksfadein.gui.components.CFISlider;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SettingsScreen
extends Screen {
    public static final MutableComponent YES = Component.translatable((String)"settings.chunksfadein.yes");
    public static final MutableComponent NO = Component.translatable((String)"settings.chunksfadein.no");
    public static final MutableComponent ON = Component.translatable((String)"settings.chunksfadein.on");
    public static final MutableComponent OFF = Component.translatable((String)"settings.chunksfadein.off");
    public static final MutableComponent RESET = Component.translatable((String)"settings.chunksfadein.reset");
    public static final MutableComponent TITLE = Component.translatable((String)"settings.chunksfadein.title");
    public static final MutableComponent UNITS_SECONDS = Component.translatable((String)"settings.chunksfadein.units.seconds");
    public static final MutableComponent UNITS_BLOCKS = Component.translatable((String)"settings.chunksfadein.units.blocks");
    public static final MutableComponent UNITS_DEGREES = Component.translatable((String)"settings.chunksfadein.units.degrees");
    public static final String MOD_ENABLED = "settings.chunksfadein.mod_enabled";
    public static final MutableComponent MOD_ENABLED_TOOLTIP = Component.translatable((String)"settings.chunksfadein.mod_enabled_tooltip");
    public static final String UPDATE_NOTIFIER_ENABLED = "settings.chunksfadein.update_notifier_enabled";
    public static final String MOD_TAB_ENABLED = "settings.chunksfadein.mod_tab_enabled";
    public static final MutableComponent MOD_TAB_TOOLTIP = Component.translatable((String)"settings.chunksfadein.mod_tab_tooltip");
    public static final String FADE_ENABLED = "settings.chunksfadein.fade_enabled";
    public static final String FADE_TYPE = "settings.chunksfadein.fade_type";
    public static final String FOG_OVERRIDE = "settings.chunksfadein.fog_override";
    public static final String FADE_TIME = "settings.chunksfadein.fade_time";
    public static final String FADE_NEAR_PLAYER = "settings.chunksfadein.fade_near_player";
    public static final String ANIMATION_ENABLED = "settings.chunksfadein.animation_enabled";
    public static final String ANIMATION_TYPE = "settings.chunksfadein.animation_type";
    public static final String ANIMATION_CURVE = "settings.chunksfadein.animation_curve";
    public static final String ANIMATION_OFFSET = "settings.chunksfadein.animation_start";
    public static final String ANIMATION_ANGLE = "settings.chunksfadein.animation_angle";
    public static final String ANIMATION_FACTOR = "settings.chunksfadein.animation_factor";
    public static final String ANIMATE_NEAR_PLAYER = "settings.chunksfadein.animate_near_player";
    public static final String ANIMATE_WITH_DH = "settings.chunksfadein.animate_with_dh";
    public static final String ANIMATION_TIME = "settings.chunksfadein.animation_time";
    public static final String CURVATURE_ENABLED = "settings.chunksfadein.world_curvature_enabled";
    public static final String CURVATURE = "settings.chunksfadein.world_curvature";
    public static final MutableComponent IRIS_WARNING = Component.translatable((String)"settings.chunksfadein.iris_warning");
    public static final int[] CURVATURE_VALUES = new int[16];
    private final Screen parent;
    private boolean dirty = false;
    private CFIListWidget list = null;

    public SettingsScreen(Screen parent) {
        super((Component)TITLE);
        this.parent = parent;
    }

    public void init() {
        this.rebuildList();
        this.addRenderableWidget((GuiEventListener)GuiUtils.doneButton(this));
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 12, -1);
    }

    public void onClose() {
        Config.save();
        if (this.dirty) {
            ShaderUtils.reloadWorldRenderer();
        }
        this.minecraft.setScreen(this.parent);
    }

    private void rebuildList() {
        if (this.list != null) {
            this.removeWidget((GuiEventListener)this.list);
        }
        this.list = this.buildList();
        this.addRenderableWidget((GuiEventListener)this.list);
    }

    private CFIListWidget buildList() {
        Runnable markDirty = () -> {
            this.dirty = true;
        };
        Runnable markEveryDirty = () -> this.dirty |= ShaderUtils.reloadOnEveryChange();
        CFIListWidget list = new CFIListWidget(this.minecraft, this, this.width, this.height - 64, 28);
        CFIButton modEnabled = CFIButton.CFIButtonBuilder.choice(MOD_ENABLED, "mod-enabled").onPress(markDirty).build();
        CFIButton updateNotifier = CFIButton.CFIButtonBuilder.toggle(UPDATE_NOTIFIER_ENABLED, "update-notifier-enabled").build();
        list.add(new AbstractWidget[]{modEnabled, updateNotifier});
        CFIButton buttonInSettings = CFIButton.CFIButtonBuilder.toggle(MOD_TAB_ENABLED, "show-mod-tab-in-settings").build();
        list.add(new AbstractWidget[]{buttonInSettings});
        CFIButton fadeEnabled = CFIButton.CFIButtonBuilder.choice(FADE_ENABLED, "fade-enabled").onPress(markDirty).applyIf(CompatibilityHook.isIrisShaderPackInUse(), b -> b.tooltip(IRIS_WARNING)).build();
        CFIButton fadeType = CFIButton.CFIButtonBuilder.cycle(FADE_TYPE, "fade-type", FadeType.class).onPress(markDirty).build();
        CFIButton fogOverride = CFIButton.CFIButtonBuilder.cycle(FOG_OVERRIDE, "fog-override", FogOverrideMode.class).onPress(markDirty).build();
        CFISlider fadeTime = new CFISlider.CFISliderBuilder().getValue(() -> (double)Config.secondsFromFadeChange() / 10.0).applyValue(v -> Config.setDouble("fade-time", v * 10.0)).displayText(v -> GuiUtils.text(FADE_TIME, String.valueOf(MathUtils.round(Config.secondsFromFadeChange(), 2))).append((Component)UNITS_SECONDS)).tooltip((Component)GuiUtils.tooltip(FADE_TIME)).build();
        CFIButton fadeNearPlayer = CFIButton.CFIButtonBuilder.choice(FADE_NEAR_PLAYER, "fade-near-player").build();
        list.add(new AbstractWidget[]{fadeEnabled});
        list.add(new AbstractWidget[]{fadeType, fadeTime, fadeTime.makeResetButton("fade-time")});
        list.add(new AbstractWidget[]{fogOverride, fadeNearPlayer});
        CFIButton animationEnabled = CFIButton.CFIButtonBuilder.choice(ANIMATION_ENABLED, "animation-enabled").onPress(markDirty).build();
        CFIButton animationCurve = CFIButton.CFIButtonBuilder.cycle(ANIMATION_CURVE, "animation-curve", Curve.class).onPress(markEveryDirty).build();
        CFIButton animationType = CFIButton.CFIButtonBuilder.cycle(ANIMATION_TYPE, "animation-type", AnimationType.class).onPress(markDirty).build();
        CFISlider animationOffset = CFISlider.CFISliderBuilder.range(ANIMATION_OFFSET, "animation-offset", (Component)UNITS_BLOCKS).onChange(markEveryDirty).build();
        CFISlider animationAngle = CFISlider.CFISliderBuilder.range(ANIMATION_ANGLE, "animation-angle", (Component)UNITS_DEGREES).onChange(markEveryDirty).build();
        CFISlider animationFactor = CFISlider.CFISliderBuilder.range(ANIMATION_FACTOR, "animation-factor", 2).onChange(markEveryDirty).build();
        CFISlider animationTime = new CFISlider.CFISliderBuilder().getValue(() -> Config.secondsFromAnimationChange() / 10.0).applyValue(v -> Config.setDouble("animation-time", v * 10.0)).onChange(markEveryDirty).displayText(v -> GuiUtils.text(ANIMATION_TIME, String.valueOf(MathUtils.round(Config.secondsFromAnimationChange(), 2))).append((Component)UNITS_SECONDS)).tooltip((Component)GuiUtils.tooltip(ANIMATION_TIME)).build();
        CFIButton animateNearPlayer = CFIButton.CFIButtonBuilder.choice(ANIMATE_NEAR_PLAYER, "animate-near-player").onPress(markEveryDirty).build();
        CFIButton animateWithDH = CFIButton.CFIButtonBuilder.choice(ANIMATE_WITH_DH, "fade-with-dh").build();
        list.add(new AbstractWidget[]{animationEnabled});
        if (Config.animationType == AnimationType.FULL) {
            list.add(new AbstractWidget[]{animationType, animationOffset, animationOffset.makeResetButton("animation-offset")});
            list.add(new AbstractWidget[]{animationCurve, animationAngle, animationAngle.makeResetButton("animation-angle")});
            list.add(new AbstractWidget[]{animateNearPlayer, animationTime, animationTime.makeResetButton("animation-time")});
            list.add(new AbstractWidget[]{animateWithDH});
        } else {
            list.add(new AbstractWidget[]{animationType, animationFactor, animationFactor.makeResetButton("animation-factor")});
            list.add(new AbstractWidget[]{animationCurve, animationTime, animationTime.makeResetButton("animation-time")});
            list.add(new AbstractWidget[]{animateNearPlayer, animateWithDH});
        }
        CFIButton curvatureEnabled = CFIButton.CFIButtonBuilder.choice(CURVATURE_ENABLED, "world-curvature-enabled").onPress(markDirty).applyIf(CompatibilityHook.isIrisShaderPackInUse(), b -> b.tooltip(IRIS_WARNING)).build();
        CFISlider curvatureFactor = new CFISlider.CFISliderBuilder().getValue(() -> (double)SettingsScreen.curvatureValueIdx(Config.worldCurvature) / 16.0).applyValue(v -> {
            Config.setInteger("world-curvature", CURVATURE_VALUES[MathUtils.roundToInt(v * 15.0)]);
            markDirty.run();
        }).displayText(v -> GuiUtils.text(CURVATURE, String.valueOf(Config.worldCurvature))).tooltip((Component)GuiUtils.tooltip(CURVATURE)).build();
        list.add(new AbstractWidget[]{curvatureEnabled, curvatureFactor, curvatureFactor.makeResetButton("world-curvature")});
        return list;
    }

    public static int curvatureValueIdx(int value) {
        for (int i = 0; i < CURVATURE_VALUES.length; ++i) {
            if (value != CURVATURE_VALUES[i]) continue;
            return i;
        }
        return 0;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            int curvatureValue = i < 8 ? (int)(-Math.pow(2.0, 16 - i)) : (int)Math.pow(2.0, i + 1);
            SettingsScreen.CURVATURE_VALUES[i] = curvatureValue;
        }
    }
}

