/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ShaderInjector {
    public static final ShaderInjector EMPTY_INJECTOR = new ShaderInjector();
    private final List<Function<String, String>> transformations = new ArrayList<Function<String, String>>();

    public void replace(String what, String ... code) {
        this.transformations.add(src -> ShaderInjector.replaceParts(src, src.replace(what, String.join((CharSequence)"\n", code))));
    }

    public void insertAfterDefines(String ... code) {
        this.insertAfterDefines(false, code);
    }

    public void insertAfterUniforms(String ... code) {
        this.insertAfterUniforms(false, code);
    }

    public void insertAfterInVars(String ... code) {
        this.insertAfterInVars(false, code);
    }

    public void insertAfterOutVars(String ... code) {
        this.insertAfterOutVars(false, code);
    }

    public void insertAfterStr(String str, String ... code) {
        this.insertAfterStr(str, false, code);
    }

    public void insertAfterDefines(boolean first, String ... code) {
        this.transformations.add(ShaderInjector.insertAfter("\n#define ", first, code));
    }

    public void insertAfterUniforms(boolean first, String ... code) {
        this.transformations.add(ShaderInjector.insertAfter("\nuniform ", first, code));
    }

    public void insertAfterInVars(boolean first, String ... code) {
        this.transformations.add(ShaderInjector.insertAfter("\nin ", first, code));
    }

    public void insertAfterOutVars(boolean first, String ... code) {
        this.transformations.add(ShaderInjector.insertAfter("\nout ", first, code));
    }

    public void insertAfterStr(String str, boolean first, String ... code) {
        this.transformations.add(ShaderInjector.insertAfter(str, first, code));
    }

    public void appendToFunction(String function, String ... code) {
        this.transformations.add(src -> {
            String indentation = ShaderInjector.getIndentation(0);
            String toInsert = ShaderInjector.applyIndentation(indentation, code);
            return ShaderInjector.insertToFunction(src, toInsert, function, -1);
        });
    }

    public void prependToFunction(String function, String ... code) {
        this.transformations.add(src -> {
            String indentation = ShaderInjector.getIndentation(0);
            String toInsert = ShaderInjector.applyIndentation(indentation, code);
            return ShaderInjector.insertToFunction(src, toInsert, function, 1);
        });
    }

    private static String applyIndentation(String indentation, String ... code) {
        return "\n" + indentation + String.join((CharSequence)("\n" + indentation), code);
    }

    private static Function<String, String> insertAfter(String what, boolean first, String ... code) {
        return src -> {
            int lastIdx = first ? src.indexOf(what) : src.lastIndexOf(what);
            String indentation = ShaderInjector.getIndentationForLine(src, lastIdx);
            int newlineIdx = src.indexOf("\n", lastIdx);
            String toInsert = ShaderInjector.applyIndentation(indentation, code);
            toInsert = ShaderInjector.replaceParts(src, toInsert);
            return ShaderInjector.insertAt(newlineIdx, src, toInsert);
        };
    }

    private static String insertToFunction(String src, String code, String function, int offset) {
        int functionIdx = src.indexOf(function);
        if (functionIdx == -1) {
            throw new IllegalStateException("Failed to append code, function '" + function + "' was not found!");
        }
        int firstBracketIdx = src.indexOf(123, functionIdx);
        int bracketCount = 0;
        code = ShaderInjector.replaceParts(src, code);
        if (offset > 0) {
            return ShaderInjector.insertAt(firstBracketIdx + offset, src, code);
        }
        if (offset < 0) {
            for (int i = firstBracketIdx; i < src.length(); ++i) {
                char symbol = src.charAt(i);
                if (symbol == '{') {
                    ++bracketCount;
                } else if (symbol == '}') {
                    --bracketCount;
                }
                if (bracketCount != 0) continue;
                return ShaderInjector.insertAt(i + offset, src, code);
            }
        }
        throw new IllegalStateException("Failed to append code, end of function '" + function + "' was not found!");
    }

    public String get(String code) {
        for (Function<String, String> function : this.transformations) {
            code = function.apply(code);
        }
        return code;
    }

    public void copyFrom(ShaderInjector injector) {
        this.transformations.addAll(injector.transformations);
    }

    private static String getIndentationForLine(String str, int pos) {
        char ch;
        Object indentation = "";
        for (int i = pos; i >= 0 && (ch = str.charAt(i)) != '\n'; --i) {
            if (ch != ' ' && ch != '\t') continue;
            indentation = (String)indentation + ch;
        }
        return indentation;
    }

    private static String getIndentation(int bracketCount) {
        Object str = "";
        for (int i = 0; i < bracketCount + 1; ++i) {
            str = (String)str + "    ";
        }
        return str;
    }

    private static String insertAt(int i, String original, String target) {
        return original.substring(0, i) + target + original.substring(i);
    }

    private static String replaceParts(String shaderCode, String toInject) {
        String id = shaderCode.contains("_draw_id") ? "_draw_id" : "_vert_mesh_id";
        toInject = toInject.replace("{mesh_id}", id);
        String fragColor = shaderCode.contains("fragColor") ? "fragColor" : "out_FragColor";
        toInject = toInject.replace("{frag_color}", fragColor);
        String color = shaderCode.contains("diffuseColor") ? "diffuseColor" : "color";
        toInject = toInject.replace("{color}", color);
        return toInject;
    }
}

