/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.textures.GpuTexture;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class Utils {
    public static int mainTargetWidth() {
        return Minecraft.getInstance().getMainRenderTarget().width;
    }

    public static int mainTargetHeight() {
        return Minecraft.getInstance().getMainRenderTarget().height;
    }

    public static int mainColorTexture() {
        GpuTexture gpuTexture = Minecraft.getInstance().getMainRenderTarget().getColorTexture();
        if (gpuTexture instanceof GlTexture) {
            GlTexture texture = (GlTexture)gpuTexture;
            return texture.glId();
        }
        return -1;
    }

    public static Vec3 cameraPosition() {
        return Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
    }

    public static int chunkRenderDistance() {
        return (int)Math.floor(Minecraft.getInstance().gameRenderer.getRenderDistance() / 16.0f);
    }

    public static void debugWriteTexture(int texture, int width, int height, File file) {
        if (file.exists()) {
            return;
        }
        file.getParentFile().mkdirs();
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glBindTexture((int)3553, (int)texture);
        GL12.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = (x + y * width) * 4;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                a = 255;
                int argb = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, height - 1 - y, argb);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

