package com.koteinik.chunksfadein.compat.mc.mixin;

import com.koteinik.chunksfadein.compat.dh.LodMaskTexture;
import com.koteinik.chunksfadein.compat.sodium.ext.RenderRegionExt;
import com.koteinik.chunksfadein.compat.sodium.ext.RenderSectionExt;
import com.koteinik.chunksfadein.compat.sodium.ext.SodiumWorldRendererExt;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.SkyFBO;
import com.koteinik.chunksfadein.core.Utils;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteIterator;
import net.caffeinemc.mods.sodium.client.world.LevelRendererExtension;
import net.minecraft.class_11658;
import net.minecraft.class_11661;
import net.minecraft.class_11954;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_761;
import net.minecraft.class_9779;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9922;
import net.minecraft.class_9960;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Iterator;

@Mixin(value = class_761.class)
public class LevelRendererMixin {
	@Shadow
	@Final
	private class_9960 targets;

	@Inject(
		method = "renderLevel",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/renderer/LevelRenderer;addMainPass(Lcom/mojang/blaze3d/framegraph/FrameGraphBuilder;Lnet/minecraft/client/renderer/culling/Frustum;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;ZLnet/minecraft/client/renderer/state/LevelRenderState;Lnet/minecraft/client/DeltaTracker;Lnet/minecraft/util/profiling/ProfilerFiller;)V"
		)
	)
	private void modifyRenderLevel(class_9922 graphicsResourceAllocator, class_9779 deltaTracker, boolean bl, class_4184 camera, Matrix4f matrix4f, Matrix4f matrix4f2, Matrix4f matrix4f3, GpuBufferSlice gpuBufferSlice, Vector4f vector4f, boolean bl2, CallbackInfo ci, @Local class_9909 frameGraphBuilder) {
		if (!Config.isModEnabled || (!Config.isFadeEnabled && !Config.isAnimationEnabled))
			return;

		if (Config.isFadeEnabled) {
			class_9916 framePass = frameGraphBuilder.method_61911("cfi_blit_sky");
			targets.field_53091 = framePass.method_61933(targets.field_53091);

			framePass.method_61929(() -> {
				SkyFBO fbo = SkyFBO.getInstance();
				if (fbo != null)
					fbo.blitFromTexture(
						Utils.mainColorTexture(),
						Utils.mainTargetWidth(),
						Utils.mainTargetHeight(),
						true
					);
			});
		}

		SodiumWorldRenderer sodiumWorld = ((LevelRendererExtension) this).sodium$getWorldRenderer();
		SodiumWorldRendererExt ext = (SodiumWorldRendererExt) sodiumWorld;
		RenderSectionManager manager = ext.getRenderSectionManager();
		if (manager == null)
			return;

		Iterator<ChunkRenderList> renderLists = manager.getRenderLists().iterator();
		while (renderLists.hasNext()) {
			ChunkRenderList renderList = renderLists.next();

			ByteIterator geometrySections = renderList.sectionsWithGeometryIterator(false);
			if (geometrySections != null)
				while (geometrySections.hasNext())
					processChunk(renderList.getRegion(), geometrySections.nextByteAsInt());
		}

		if (CompatibilityHook.isDHRenderingEnabled())
			LodMaskTexture.createAndUpdate();
	}

	@Inject(
		method = "submitBlockEntities",
		at = @At(
			value = "INVOKE",
			target = "Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V",
			shift = At.Shift.AFTER
		)
	)
	private void modifySubmitBlockEntities(
		class_4587 matrices,
		class_11658 levelRenderState,
		class_11661 submitNodeStorage,
		CallbackInfo ci,
		@Local class_11954 state
	) {
		if (!Config.isModEnabled || (!Config.isAnimationEnabled && !Config.isCurvatureEnabled))
			return;

		SodiumWorldRendererExt ext = ((SodiumWorldRendererExt) SodiumWorldRenderer.instance());
		if (ext.getRenderSectionManager() == null)
			return;

		float[] offset = ext.getAnimationOffset(state.field_62673.method_46558());

		matrices.method_46416(offset[0], offset[1], offset[2]);
	}

	private static void processChunk(RenderRegion region, int sectionIndex) {
		RenderSection section = region.getSection(sectionIndex);
		if (section == null) return;

		RenderRegionExt regionExt = (RenderRegionExt) region;

		regionExt.processChunk((RenderSectionExt) section, sectionIndex);
	}
}
