package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.core.ModrinthApi.ModrinthVersion;
import com.koteinik.chunksfadein.platform.Services;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class UpdateNotifier {
	public static void checkAndNotify() {
		new Thread(() -> {
			try {
				List<ModrinthVersion> newVersions = ModrinthApi.getLatestVersions().stream()
					.takeWhile(UpdateNotifier::isNewerVersion)
					.toList();

				if (!newVersions.isEmpty()) {
					ModrinthVersion latestVersion = newVersions.getFirst();

					List<class_2561> textList = new ArrayList<>();
					textList.add(class_2561.method_43470("§7New version of §2Chunks Fade In §7is available!"));

					class_2583 linkStyle = class_2583.field_24360.method_10958(new class_2558.class_10608(URI.create(latestVersion.downloadUrl)));

					String versions = newVersions.size() == 1
						? "§6v" + latestVersion.version
						: "§6v%s§7-§6v%s".formatted(newVersions.getLast().version, latestVersion.version);
					textList.add(class_2561.method_43470(versions + "§r§7 changelog:"));

					String changelogs = String.join(
						"\n", newVersions.stream()
							.map(v -> v.changelog)
							.toList()
					).replace("\r", "");
					textList.add(class_2561.method_43470("§7" + changelogs));

					textList.addAll(class_2561.method_43470("§7§nClick to download").method_36136(linkStyle));

					class_310 minecraft = class_310.method_1551();
					class_746 player = minecraft.field_1724;

					if (player == null)
						return;

					for (class_2561 text : textList)
						class_310.method_1551().execute(() -> player.method_7353(text, false));
				}
			} catch (Exception e) {
				Logger.warn("Failed to get latest mod version!");
				e.printStackTrace();
			}
		}).start();
	}

	private static boolean isNewerVersion(ModrinthVersion modrinthVersion) {
		if (modrinthVersion == null)
			return false;

		return Services.PLATFORM.getModVersion().compareTo(modrinthVersion.version) < 0;
	}
}
