package com.koteinik.chunksfadein.crowdin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_9224;

/**
 * Code taken and modified from https://github.com/gbl/CrowdinTranslate
 */
public class TranslationsPack implements class_3262 {
	@Override
	public class_7367<InputStream> method_14410(String... names) {
		File file = new File(Translations.getPackRootDir(), names[0]);
		if (file.exists())
			return class_7367.create(file.toPath());

		return null;
	}

	@Override
	public class_7367<InputStream> method_14405(class_3264 type, class_2960 loc) {
		return this.method_14410(type.method_14413() + "/" + loc.method_12836() + "/" + loc.method_12832());
	}

	@Override
	public void method_14408(class_3264 type, String namespace, String prefix, class_7664 consumer) {
		String[] files = new File(Translations.getPackRootDir(), "assets/" + namespace + "/" + prefix).list();
		if (files == null || files.length == 0)
			return;

		List<class_2960> results = Arrays.asList(files)
			.stream()
			.map(TranslationsPack::fromPath)
			.collect(Collectors.toList());

		for (class_2960 result : results)
			consumer.accept(result, method_14405(type, result));
	}

	@Override
	public Set<String> method_14406(class_3264 type) {
		return Set.of("chunksfadein");
	}

	@Override
	public <T> T method_14407(class_7677<T> type) throws IOException {
		return null;
	}

	@Override
	public class_9224 method_56926() {
		return new class_9224("chunksfadein-translations",
			class_2561.method_43470("Chunks Fade In internal pack with translations"),
			class_5352.field_25347,
			Optional.empty());
	}

	@Override
	public void close() {}

	private static class_2960 fromPath(String path) {
		if (path.startsWith("assets/"))
			path = path.substring("assets/".length());
		String[] split = path.split("/", 2);

		return class_2960.method_60655(split[0], split[1]);
	}
}
