/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.core.ModrinthApi;
import com.koteinik.chunksfadein.platform.Services;
import java.net.URI;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class UpdateNotifier {
    public static void checkAndNotify() {
        new Thread(() -> {
            ModrinthApi.ModrinthVersion latestVersion = ModrinthApi.getLatestModVersion();
            if (UpdateNotifier.isNewerVersion(latestVersion)) {
                ArrayList<MutableComponent> textList = new ArrayList<MutableComponent>();
                textList.add(Component.literal((String)"\u00a77New version of \u00a72Chunks fade in \u00a77is available!"));
                Style linkStyle = Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(latestVersion.downloadUrl)));
                textList.add(Component.literal((String)("\u00a77v" + String.valueOf(latestVersion.version) + "\u00a7r\u00a77 changelog:")));
                textList.add(Component.literal((String)("\u00a77" + latestVersion.changelog)));
                textList.addAll(Component.literal((String)"\u00a77\u00a7nClick to download").toFlatList(linkStyle));
                Minecraft minecraft = Minecraft.getInstance();
                LocalPlayer player = minecraft.player;
                if (player == null) {
                    return;
                }
                for (Component component : textList) {
                    player.displayClientMessage(component, false);
                }
            }
        }).start();
    }

    private static boolean isNewerVersion(ModrinthApi.ModrinthVersion modrinthVersion) {
        if (modrinthVersion == null) {
            return false;
        }
        return Services.PLATFORM.getModVersion().compareTo(modrinthVersion.version) < 0;
    }
}

