package com.koteinik.chunksfadein.gui.components;

import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4265.class_4266;
import net.minecraft.class_437;
import net.minecraft.class_6379;

public class CFIWidgetsEntry extends class_4266<CFIWidgetsEntry> {
	private static final int SPACING_X = 4;
	private static final int BUTTON_W = 180;

	private final List<class_339> widgets;
	private final class_437 parent;
	private final int y;

	public CFIWidgetsEntry(List<class_339> widgets, class_437 parent, int y) {
		this.widgets = widgets;
		this.parent = parent;
		this.y = y;
	}

	@Override
	public List<? extends class_364> method_25396() {
		return widgets;
	}

	@Override
	public List<? extends class_6379> method_37025() {
		return widgets;
	}

	@Override
	public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
		for (int i = 0; i < widgets.size(); i++) {
			class_339 widget = widgets.get(i);

			int gridX = i;
			if (widgets.size() > 1 && i == 0)
				gridX = -1;

			widget.method_48229(calculateX(gridX), y);
			widget.method_25394(context, mouseX, mouseY, tickDelta);
		}
	}

	private int calculateX(int column) {
		int halfScreen = parent.field_22789 / 2;

		return column == 0
			? halfScreen - BUTTON_W / 2
			: halfScreen + BUTTON_W * (column - (column < 0 ? 0 : 1)) + SPACING_X * column;
	}
}
