/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.gui;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.ShaderUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationCurve;
import com.koteinik.chunksfadein.core.AnimationType;
import com.koteinik.chunksfadein.core.FadeCurve;
import com.koteinik.chunksfadein.core.FadeMixType;
import com.koteinik.chunksfadein.core.FadeType;
import com.koteinik.chunksfadein.core.FogOverrideMode;
import com.koteinik.chunksfadein.crowdin.Translations;
import com.koteinik.chunksfadein.gui.GuiUtils;
import com.koteinik.chunksfadein.gui.components.CFIButton;
import com.koteinik.chunksfadein.gui.components.CFIListWidget;
import com.koteinik.chunksfadein.gui.components.CFISlider;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class SettingsScreen
extends class_437 {
    public static final class_5250 YES = Translations.translatable("settings.chunksfadein.yes");
    public static final class_5250 NO = Translations.translatable("settings.chunksfadein.no");
    public static final class_5250 ON = Translations.translatable("settings.chunksfadein.on");
    public static final class_5250 OFF = Translations.translatable("settings.chunksfadein.off");
    public static final class_5250 RESET = Translations.translatable("settings.chunksfadein.reset");
    public static final class_5250 TITLE = Translations.translatable("settings.chunksfadein.title");
    public static final class_5250 UNITS_SECONDS = Translations.translatable("settings.chunksfadein.units.seconds");
    public static final class_5250 UNITS_BLOCKS = Translations.translatable("settings.chunksfadein.units.blocks");
    public static final class_5250 UNITS_DEGREES = Translations.translatable("settings.chunksfadein.units.degrees");
    public static final String MOD_ENABLED = "settings.chunksfadein.mod_enabled";
    public static final class_5250 MOD_ENABLED_TOOLTIP = Translations.translatable("settings.chunksfadein.mod_enabled_tooltip");
    public static final String UPDATE_NOTIFIER_ENABLED = "settings.chunksfadein.update_notifier_enabled";
    public static final String MOD_TAB_ENABLED = "settings.chunksfadein.mod_tab_enabled";
    public static final class_5250 MOD_TAB_TOOLTIP = Translations.translatable("settings.chunksfadein.mod_tab_tooltip");
    public static final String FADE_ENABLED = "settings.chunksfadein.fade_enabled";
    public static final String FADE_PATCH_SHADERS = "settings.chunksfadein.fade_patch_shaders";
    public static final String FADE_TYPE = "settings.chunksfadein.fade_type";
    public static final String FADE_CURVE = "settings.chunksfadein.fade_curve";
    public static final String FADE_MIX_TYPE = "settings.chunksfadein.fade_mix_type";
    public static final String FOG_OVERRIDE = "settings.chunksfadein.fog_override";
    public static final String FADE_TIME = "settings.chunksfadein.fade_time";
    public static final String FADE_NEAR_PLAYER = "settings.chunksfadein.fade_near_player";
    public static final String ANIMATION_ENABLED = "settings.chunksfadein.animation_enabled";
    public static final String ANIMATION_PATCH_SHADERS = "settings.chunksfadein.animation_patch_shaders";
    public static final String ANIMATION_TYPE = "settings.chunksfadein.animation_type";
    public static final String ANIMATION_CURVE = "settings.chunksfadein.animation_curve";
    public static final String ANIMATION_OFFSET = "settings.chunksfadein.animation_start";
    public static final String ANIMATION_ANGLE = "settings.chunksfadein.animation_angle";
    public static final String ANIMATION_FACTOR = "settings.chunksfadein.animation_factor";
    public static final String ANIMATE_NEAR_PLAYER = "settings.chunksfadein.animate_near_player";
    public static final String ANIMATE_WITH_DH = "settings.chunksfadein.animate_with_dh";
    public static final String ANIMATION_TIME = "settings.chunksfadein.animation_time";
    public static final String CURVATURE_ENABLED = "settings.chunksfadein.world_curvature_enabled";
    public static final String CURVATURE_PATCH_SHADERS = "settings.chunksfadein.world_curvature_patch_shaders";
    public static final String CURVATURE = "settings.chunksfadein.world_curvature";
    public static final class_5250 IRIS_WARNING = Translations.translatable("settings.chunksfadein.iris_warning");
    public static final int[] CURVATURE_VALUES = new int[16];
    private final class_437 parent;
    private boolean dirty = false;
    private CFIListWidget list = null;

    public SettingsScreen(class_437 parent) {
        super((class_2561)TITLE);
        this.parent = parent;
    }

    public void method_25426() {
        this.rebuildList();
        this.method_37063((class_364)GuiUtils.doneButton(this));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, -1);
    }

    public void method_25419() {
        Config.save();
        if (this.dirty) {
            ShaderUtils.reloadWorldRenderer();
        }
        this.field_22787.method_1507(this.parent);
    }

    private void rebuildList() {
        if (this.list != null) {
            this.method_37066((class_364)this.list);
        }
        this.list = this.buildList();
        this.method_37063((class_364)this.list);
    }

    private CFIListWidget buildList() {
        Runnable markDirty = () -> {
            this.dirty = true;
        };
        Runnable markEveryDirty = () -> this.dirty |= ShaderUtils.reloadOnEveryChange();
        CFIListWidget list = new CFIListWidget(this.field_22787, this, this.field_22789, this.field_22790 - 64, 28);
        CFIButton modEnabled = CFIButton.CFIButtonBuilder.choice(MOD_ENABLED, "mod-enabled").onPress(markDirty).build();
        CFIButton updateNotifier = CFIButton.CFIButtonBuilder.toggle(UPDATE_NOTIFIER_ENABLED, "update-notifier-enabled").build();
        list.add(new class_339[]{modEnabled, updateNotifier});
        CFIButton buttonInSettings = CFIButton.CFIButtonBuilder.toggle(MOD_TAB_ENABLED, "show-mod-tab-in-settings").build();
        list.add(new class_339[]{buttonInSettings});
        CFIButton fadeEnabled = CFIButton.CFIButtonBuilder.choice(FADE_ENABLED, "fade-enabled").onPress(markDirty).applyIf(CompatibilityHook.isIrisShaderPackInUse(), b -> b.tooltip(IRIS_WARNING)).build();
        CFIButton fadePatchShaders = CFIButton.CFIButtonBuilder.choice(FADE_PATCH_SHADERS, "fade-patch-shaders").onPress(markEveryDirty).build();
        CFIButton fadeType = CFIButton.CFIButtonBuilder.cycle(FADE_TYPE, "fade-type", FadeType.class).onPress(markDirty).build();
        CFIButton fadeCurve = CFIButton.CFIButtonBuilder.cycle(FADE_CURVE, "fade-curve", FadeCurve.class).build();
        CFIButton fadeMixType = CFIButton.CFIButtonBuilder.cycle(FADE_MIX_TYPE, "fade-mix-type", FadeMixType.class).onPress(markDirty).build();
        CFIButton fogOverride = CFIButton.CFIButtonBuilder.cycle(FOG_OVERRIDE, "fog-override", FogOverrideMode.class).onPress(markDirty).build();
        CFISlider fadeTime = new CFISlider.CFISliderBuilder().getValue(() -> (double)Config.secondsFromFadeChange() / 10.0).applyValue(v -> Config.setDouble("fade-time", v * 10.0)).displayText(v -> GuiUtils.text(FADE_TIME, String.valueOf(MathUtils.round(Config.secondsFromFadeChange(), 2))).method_10852((class_2561)UNITS_SECONDS)).tooltip((class_2561)GuiUtils.tooltip(FADE_TIME)).build();
        CFIButton fadeNearPlayer = CFIButton.CFIButtonBuilder.choice(FADE_NEAR_PLAYER, "fade-near-player").build();
        list.add(new class_339[]{fadeEnabled});
        list.add(new class_339[]{fadePatchShaders});
        list.add(new class_339[]{fadeType, fadeTime, fadeTime.makeResetButton("fade-time")});
        list.add(new class_339[]{fadeCurve, fadeMixType});
        list.add(new class_339[]{fogOverride, fadeNearPlayer});
        CFIButton animationEnabled = CFIButton.CFIButtonBuilder.choice(ANIMATION_ENABLED, "animation-enabled").onPress(markDirty).build();
        CFIButton animationPatchShaders = CFIButton.CFIButtonBuilder.choice(ANIMATION_PATCH_SHADERS, "animation-patch-shaders").onPress(markEveryDirty).build();
        CFIButton animationCurve = CFIButton.CFIButtonBuilder.cycle(ANIMATION_CURVE, "animation-curve", AnimationCurve.class).onPress(markEveryDirty).build();
        CFIButton animationType = CFIButton.CFIButtonBuilder.cycle(ANIMATION_TYPE, "animation-type", AnimationType.class).onPress(markDirty).build();
        CFISlider animationOffset = CFISlider.CFISliderBuilder.range(ANIMATION_OFFSET, "animation-offset", (class_2561)UNITS_BLOCKS).onChange(markEveryDirty).build();
        CFISlider animationAngle = CFISlider.CFISliderBuilder.range(ANIMATION_ANGLE, "animation-angle", (class_2561)UNITS_DEGREES).onChange(markEveryDirty).build();
        CFISlider animationFactor = CFISlider.CFISliderBuilder.range(ANIMATION_FACTOR, "animation-factor", 2).onChange(markEveryDirty).build();
        CFISlider animationTime = new CFISlider.CFISliderBuilder().getValue(() -> Config.secondsFromAnimationChange() / 10.0).applyValue(v -> Config.setDouble("animation-time", v * 10.0)).onChange(markEveryDirty).displayText(v -> GuiUtils.text(ANIMATION_TIME, String.valueOf(MathUtils.round(Config.secondsFromAnimationChange(), 2))).method_10852((class_2561)UNITS_SECONDS)).tooltip((class_2561)GuiUtils.tooltip(ANIMATION_TIME)).build();
        CFIButton animateNearPlayer = CFIButton.CFIButtonBuilder.choice(ANIMATE_NEAR_PLAYER, "animate-near-player").onPress(markEveryDirty).build();
        CFIButton animateWithDH = CFIButton.CFIButtonBuilder.choice(ANIMATE_WITH_DH, "fade-with-dh").build();
        list.add(new class_339[]{animationEnabled});
        list.add(new class_339[]{animationPatchShaders});
        if (Config.animationType == AnimationType.FULL) {
            list.add(new class_339[]{animationType, animationOffset, animationOffset.makeResetButton("animation-offset")});
            list.add(new class_339[]{animationCurve, animationAngle, animationAngle.makeResetButton("animation-angle")});
            list.add(new class_339[]{animateNearPlayer, animationTime, animationTime.makeResetButton("animation-time")});
            list.add(new class_339[]{animateWithDH});
        } else {
            list.add(new class_339[]{animationType, animationFactor, animationFactor.makeResetButton("animation-factor")});
            list.add(new class_339[]{animationCurve, animationTime, animationTime.makeResetButton("animation-time")});
            list.add(new class_339[]{animateNearPlayer, animateWithDH});
        }
        CFIButton curvatureEnabled = CFIButton.CFIButtonBuilder.choice(CURVATURE_ENABLED, "world-curvature-enabled").onPress(markDirty).applyIf(CompatibilityHook.isIrisShaderPackInUse(), b -> b.tooltip(IRIS_WARNING)).build();
        CFIButton curvaturePatchShaders = CFIButton.CFIButtonBuilder.choice(CURVATURE_PATCH_SHADERS, "world-curvature-patch-shaders").onPress(markEveryDirty).build();
        CFISlider curvatureFactor = new CFISlider.CFISliderBuilder().getValue(() -> (double)SettingsScreen.curvatureValueIdx(Config.worldCurvature) / 16.0).applyValue(v -> {
            Config.setInteger("world-curvature", CURVATURE_VALUES[MathUtils.roundToInt(v * 15.0)]);
            markDirty.run();
        }).displayText(v -> GuiUtils.text(CURVATURE, String.valueOf(Config.worldCurvature))).tooltip((class_2561)GuiUtils.tooltip(CURVATURE)).build();
        list.add(new class_339[]{curvatureEnabled});
        list.add(new class_339[]{curvaturePatchShaders, curvatureFactor, curvatureFactor.makeResetButton("world-curvature")});
        return list;
    }

    public static int curvatureValueIdx(int value) {
        for (int i = 0; i < CURVATURE_VALUES.length; ++i) {
            if (value != CURVATURE_VALUES[i]) continue;
            return i;
        }
        return 0;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            int curvatureValue = i < 8 ? (int)(-Math.pow(2.0, 16 - i)) : (int)Math.pow(2.0, i + 1);
            SettingsScreen.CURVATURE_VALUES[i] = curvatureValue;
        }
    }
}

