/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.crowdin;

import com.google.gson.JsonObject;
import com.koteinik.chunksfadein.Logger;
import com.koteinik.chunksfadein.NetworkUtils;
import com.koteinik.chunksfadein.crowdin.Translations;
import com.koteinik.chunksfadein.platform.Services;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public class TranslationsDownloader
extends Thread {
    private static final String CROWDIN_ID = "593943";
    private static final String CROWDIN_TOKEN = "2afc5ca9fa1d43622545f8115ea72ddb795b49c4a70aa5b845f1f76ccb6ee052e89a8b78b07bd282";
    private static final String API_LINK = "https://api.crowdin.com/api/v2";
    private static final String LIST_BUILDS = "https://api.crowdin.com/api/v2/projects/593943/translations/builds";
    private static final String GET_BUILD = "https://api.crowdin.com/api/v2/projects/593943/translations/builds/%s/download";
    private static final Map<String, String> mcCodetoCrowdinCode = new HashMap<String, String>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    private static void add(String mc, String ci) {
        mcCodetoCrowdinCode.put(mc, ci);
    }

    private static File cacheDir() {
        return new File(Services.PLATFORM.getConfigDirectory().getParentFile(), "cache/chunksfadein/translations");
    }

    @Override
    public void run() {
        File dir;
        Map<String, byte[]> translations = new HashMap();
        try {
            dir = TranslationsDownloader.cacheDir();
            if (dir.exists()) {
                for (File file : Objects.requireNonNull(dir.listFiles())) {
                    if (!file.isFile()) continue;
                    translations.put(file.getName(), FileUtils.readFileToByteArray((File)file));
                }
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to read cached translations:", e);
        }
        try {
            translations = this.executor.submit(this::getCrowdinTranslations).get(30L, TimeUnit.SECONDS);
            try {
                dir = TranslationsDownloader.cacheDir();
                dir.mkdirs();
                translations.forEach((key, bytes) -> {
                    try {
                        FileUtils.writeByteArrayToFile((File)new File(dir, (String)key), (byte[])bytes);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                Logger.warn("Failed to cache translations:", e);
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to get crowdin translations:", e);
            Logger.warn("Using cached translations.");
        }
        HashMap<String, Map<String, String>> translationsMap = new HashMap<String, Map<String, String>>();
        block7: for (Map.Entry entry : mcCodetoCrowdinCode.entrySet()) {
            String[] sourcesByPreference;
            for (String attemptingSource : sourcesByPreference = ((String)entry.getValue()).split(",")) {
                byte[] buffer = (byte[])translations.get(attemptingSource);
                if (buffer == null) continue;
                translationsMap.put((String)entry.getKey(), Translations.parseJsonTranslations(new String(buffer)));
                continue block7;
            }
        }
        Translations.addTranslations(translationsMap);
    }

    private Map<String, byte[]> getCrowdinTranslations() throws IOException {
        ZipInputStream zis = null;
        Pattern pattern = Pattern.compile("^([a-z]{2}(-[A-Z]{2})?)/(.+\\.json)$");
        HashMap<String, byte[]> zipContents = new HashMap<String, byte[]>();
        try {
            ZipEntry entry;
            String lastBuildId = this.get(LIST_BUILDS).getAsJsonArray("data").asList().stream().map(e -> e.getAsJsonObject().getAsJsonObject("data")).filter(e -> e.get("status").getAsString().equals("finished")).map(e -> e.get("id").getAsString()).findFirst().get();
            String buildUrl = this.get(GET_BUILD.formatted(lastBuildId)).getAsJsonObject("data").get("url").getAsString();
            URL url = URI.create(buildUrl).toURL();
            zis = new ZipInputStream(url.openStream());
            while ((entry = zis.getNextEntry()) != null) {
                String path = entry.getName();
                Matcher matcher = pattern.matcher(path);
                if (!matcher.matches()) continue;
                String crowdinLang = matcher.group(1);
                String origFileName = matcher.group(3);
                if (entry.getSize() > 10000000L) {
                    throw new IOException("file too large: " + entry.getName() + ": " + entry.getSize());
                }
                byte[] zipFileContent = this.getZipStreamContent(zis, (int)entry.getSize());
                if (zipContents.containsKey(crowdinLang)) {
                    System.err.println("More than one file for " + crowdinLang + ", ignoring " + origFileName);
                    continue;
                }
                zipContents.put(matcher.group(1), zipFileContent);
            }
        }
        catch (IOException e2) {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e2;
        }
        return zipContents;
    }

    private JsonObject get(String url) {
        return NetworkUtils.executeGet(url, Map.of("Authorization", "Bearer 2afc5ca9fa1d43622545f8115ea72ddb795b49c4a70aa5b845f1f76ccb6ee052e89a8b78b07bd282"), Map.of()).getAsJsonObject();
    }

    private byte[] getZipStreamContent(InputStream is, int size) throws IOException {
        int readNow;
        byte[] buf = new byte[size];
        int totalRead = 0;
        for (int toRead = size; toRead > 0; toRead -= readNow) {
            readNow = is.read(buf, totalRead, toRead);
            if (readNow <= 0) {
                throw new IOException("premature end of stream");
            }
            totalRead += readNow;
        }
        return buf;
    }

    static {
        TranslationsDownloader.add("af_za", "af");
        TranslationsDownloader.add("ar_sa", "ar");
        TranslationsDownloader.add("ast_es", "ast");
        TranslationsDownloader.add("az_az", "az");
        TranslationsDownloader.add("ba_ru", "ba");
        TranslationsDownloader.add("bar", "bar");
        TranslationsDownloader.add("be_by", "be");
        TranslationsDownloader.add("bg_bg", "bg");
        TranslationsDownloader.add("br_fr", "br-FR");
        TranslationsDownloader.add("brb", "brb");
        TranslationsDownloader.add("bs_ba", "bs");
        TranslationsDownloader.add("ca_es", "ca");
        TranslationsDownloader.add("cs_cz", "cs");
        TranslationsDownloader.add("cy_gb", "cy");
        TranslationsDownloader.add("da_dk", "da");
        TranslationsDownloader.add("de_at", "de-AT,de");
        TranslationsDownloader.add("de_ch", "de-CH,de");
        TranslationsDownloader.add("de_de", "de");
        TranslationsDownloader.add("el_gr", "el");
        TranslationsDownloader.add("en_au", "en-AU,en-GB,en-US");
        TranslationsDownloader.add("en_ca", "en-CA,en-GB,en-US");
        TranslationsDownloader.add("en_gb", "en-GB,en-US");
        TranslationsDownloader.add("en_nz", "en-NZ,en-GB,en-US");
        TranslationsDownloader.add("en_pt", "en-PT,en-GB,en-US");
        TranslationsDownloader.add("en_ud", "en-UD,en-GB,en-US");
        TranslationsDownloader.add("en_us", "en-US");
        TranslationsDownloader.add("enp", "enp");
        TranslationsDownloader.add("en_ws", "en-WS");
        TranslationsDownloader.add("en_7s", "en-PT");
        TranslationsDownloader.add("en_ud", "en-UD");
        TranslationsDownloader.add("eo_uy", "eo");
        TranslationsDownloader.add("es_ar", "es-AR,es-ES");
        TranslationsDownloader.add("es_cl", "es-CL,es-ES");
        TranslationsDownloader.add("es_ec", "es-EC,es-ES");
        TranslationsDownloader.add("es_es", "es-ES");
        TranslationsDownloader.add("es_mx", "es-MX,es-ES");
        TranslationsDownloader.add("es_uy", "es-UY,es-ES");
        TranslationsDownloader.add("es_ve", "es-VE,es-ES");
        TranslationsDownloader.add("esan", "esan");
        TranslationsDownloader.add("et_ee", "et");
        TranslationsDownloader.add("eu_es", "eu");
        TranslationsDownloader.add("fa_ir", "fa");
        TranslationsDownloader.add("fi_fi", "fi");
        TranslationsDownloader.add("fil_ph", "fil");
        TranslationsDownloader.add("fo_fo", "fo");
        TranslationsDownloader.add("fr_ca", "fr-CA,fr");
        TranslationsDownloader.add("fr_fr", "fr");
        TranslationsDownloader.add("fra_de", "fra-DE");
        TranslationsDownloader.add("fy_nl", "fy-NL");
        TranslationsDownloader.add("ga_ie", "ga-IE");
        TranslationsDownloader.add("gd_gb", "gd");
        TranslationsDownloader.add("gl_es", "gl");
        TranslationsDownloader.add("haw_us", "haw");
        TranslationsDownloader.add("he_il", "he");
        TranslationsDownloader.add("hi_in", "hi");
        TranslationsDownloader.add("hr_hr", "hr");
        TranslationsDownloader.add("hu_hu", "hu");
        TranslationsDownloader.add("hy_am", "hy-AM");
        TranslationsDownloader.add("id_id", "id");
        TranslationsDownloader.add("ig_ng", "ig");
        TranslationsDownloader.add("io_en", "ido");
        TranslationsDownloader.add("is_is", "is");
        TranslationsDownloader.add("isv", "isv");
        TranslationsDownloader.add("it_it", "it");
        TranslationsDownloader.add("ja_jp", "ja");
        TranslationsDownloader.add("jbo_en", "jbo");
        TranslationsDownloader.add("ka_ge", "ka");
        TranslationsDownloader.add("kk_kz", "kk");
        TranslationsDownloader.add("kn_in", "kn");
        TranslationsDownloader.add("ko_kr", "ko");
        TranslationsDownloader.add("ksh", "ksh");
        TranslationsDownloader.add("kw_gb", "kw");
        TranslationsDownloader.add("la_la", "la-LA");
        TranslationsDownloader.add("lb_lu", "lb");
        TranslationsDownloader.add("li_li", "li");
        TranslationsDownloader.add("lol_us", "lol");
        TranslationsDownloader.add("lt_lt", "lt");
        TranslationsDownloader.add("lv_lv", "lv");
        TranslationsDownloader.add("lzh", "lzh");
        TranslationsDownloader.add("mi_NZ", "mi");
        TranslationsDownloader.add("mk_mk", "mk");
        TranslationsDownloader.add("mn_mn", "mn");
        TranslationsDownloader.add("ms_my", "ms");
        TranslationsDownloader.add("mt_mt", "mt");
        TranslationsDownloader.add("nds_de", "nds");
        TranslationsDownloader.add("nl_be", "nl-BE,nl");
        TranslationsDownloader.add("nl_nl", "nl");
        TranslationsDownloader.add("nn_no", "nn-NO,no");
        TranslationsDownloader.add("no_no", "no,nb");
        TranslationsDownloader.add("oc_fr", "oc");
        TranslationsDownloader.add("ovd", "ovd");
        TranslationsDownloader.add("pl_pl", "pl");
        TranslationsDownloader.add("pt_br", "pt-BR,pt-PT");
        TranslationsDownloader.add("pt_pt", "pt-PT,pt-BR");
        TranslationsDownloader.add("qya_aa", "qya-AA");
        TranslationsDownloader.add("ro_ro", "ro");
        TranslationsDownloader.add("rpr", "rpr");
        TranslationsDownloader.add("ru_ru", "ru");
        TranslationsDownloader.add("se_no", "se");
        TranslationsDownloader.add("sk_sk", "sk");
        TranslationsDownloader.add("sl_si", "sl");
        TranslationsDownloader.add("so_so", "so");
        TranslationsDownloader.add("sq_al", "sq");
        TranslationsDownloader.add("sr_sp", "sr");
        TranslationsDownloader.add("sv_se", "sv-SE");
        TranslationsDownloader.add("sxu", "sxu");
        TranslationsDownloader.add("szl", "szl");
        TranslationsDownloader.add("ta_in", "ta");
        TranslationsDownloader.add("th_th", "th");
        TranslationsDownloader.add("tl_ph", "tl");
        TranslationsDownloader.add("tlh_aa", "tlh-AA");
        TranslationsDownloader.add("tr_tr", "tr");
        TranslationsDownloader.add("tt_ru", "tt-RU");
        TranslationsDownloader.add("uk_ua", "uk");
        TranslationsDownloader.add("val_es", "val-ES");
        TranslationsDownloader.add("vec_it", "vec");
        TranslationsDownloader.add("vi_vn", "vi");
        TranslationsDownloader.add("yi_de", "yi");
        TranslationsDownloader.add("yo_ng", "yo");
        TranslationsDownloader.add("zh_cn", "zh-CN,zh-HK");
        TranslationsDownloader.add("zh_hk", "zh-HK,zh-CN");
        TranslationsDownloader.add("zh_tw", "zh-TW");
    }
}

