package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.crowdin.Translations;
import com.koteinik.chunksfadein.gui.SettingsScreen;
import net.caffeinemc.mods.sodium.client.gui.options.TextProvider;
import net.minecraft.class_2561;
import java.util.function.Function;

@SuppressWarnings("unused")
public enum AnimationCurve implements TranslatableEnum, TextProvider {
	LINEAR((f) -> f),
	EASE_OUT((f) -> 1f - MathUtils.pow(1 - f, 3)),
	EASE_CIRCULAR((f) -> {
		final float f1 = 2 * f;

		return f < 0.5f
			? (1 - MathUtils.sqrt(1f - MathUtils.pow(f1, 2))) / 2f
			: (MathUtils.sqrt(1f - MathUtils.pow(-f1 + 2, 2)) + 1) / 2f;
	}),
	BOUNCE((f) -> {
		if (f < 1 / CurveConstants.d1) {
			return CurveConstants.n1 * f * f;
		} else if (f < 2 / CurveConstants.d1) {
			return CurveConstants.n1 * (f -= 1.5f / CurveConstants.d1) * f + 0.75f;
		} else if (f < 2.5 / CurveConstants.d1) {
			return CurveConstants.n1 * (f -= 2.25f / CurveConstants.d1) * f + 0.9375f;
		} else {
			return CurveConstants.n1 * (f -= 2.625f / CurveConstants.d1) * f + 0.984375f;
		}
	});

	public final class_2561 translation;
	private final Function<Float, Float> calculate;

	AnimationCurve(Function<Float, Float> calculate) {
		this.calculate = calculate;
		this.translation = Translations.translatable(SettingsScreen.ANIMATION_CURVE + "." + name().toLowerCase());
	}

	public Float calculate(Float in) {
		return calculate.apply(in);
	}

	@Override
	public class_2561 getTranslation() {
		return translation;
	}

	@Override
	public class_2561 getLocalizedName() {
		return getTranslation();
	}
}

class CurveConstants {
	public static final float n1 = 7.5625f;
	public static final float d1 = 2.75f;
}
