package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.crowdin.Translations;
import com.koteinik.chunksfadein.gui.SettingsScreen;
import net.minecraft.network.chat.Component;

public enum FogOverrideMode implements TranslatableEnum {
	BOTH,
	CYLINDRICAL,
	SPHERICAL,
	NONE;

	public final Component translation;

	FogOverrideMode() {
		this.translation = Translations.translatable(SettingsScreen.FOG_OVERRIDE + "." + name().toLowerCase());
	}

	@Override
	public Component getTranslation() {
		return translation;
	}
}
