/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.config;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.ConfigEntry;
import com.moandjiezana.toml.Toml;

public class ConfigEntryDoubleLimitable
extends ConfigEntry<Double> {
    private final double max;
    private final double min;

    public ConfigEntryDoubleLimitable(double min, double max, double defaultValue, String description, String configKey) {
        super(defaultValue, configKey, description, ConfigEntry.Type.DOUBLE);
        this.max = max;
        this.min = min;
    }

    @Override
    public void load(Toml toml) {
        Double tomlValue = (Double)this.type.get(toml, this.configKey);
        if (tomlValue == null) {
            tomlValue = (Double)this.defaultValue;
        }
        this.value = tomlValue;
        this.clampValue();
        this.pollListeners();
    }

    @Override
    public Double set(Double value) {
        this.value = value;
        this.clampValue();
        this.pollListeners();
        return (Double)this.value;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public String toString() {
        return "# %s\n#\n".formatted(this.description.replace("\n", "\n# ")) + "# Default: %s\n".formatted(this.defaultValue) + "# Range: [%s..%s]\n".formatted(this.min, this.max) + "%s = %s\n".formatted(this.configKey, this.type.makeString(this.value));
    }

    private void clampValue() {
        this.value = MathUtils.clamp((Double)this.value, this.min, this.max);
    }
}

