/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.compat.iris;

import com.koteinik.chunksfadein.core.FadeShader;
import io.github.douira.glsl_transformer.ast.data.ChildNodeList;
import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.declaration.Declaration;
import io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import io.github.douira.glsl_transformer.ast.node.declaration.InterfaceBlockDeclaration;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.LiteralExpression;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.AssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.FunctionCallExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.MemberAccessExpression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.FunctionDefinition;
import io.github.douira.glsl_transformer.ast.node.statement.Statement;
import io.github.douira.glsl_transformer.ast.node.type.FullySpecifiedType;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.LayoutQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.LayoutQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.NamedLayoutQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.print.ASTPrinter;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.RootSupplier;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.ast.transform.ASTTransformer;
import io.github.douira.glsl_transformer.ast.transform.JobParameters;
import io.github.douira.glsl_transformer.ast.traversal.ASTListener;
import io.github.douira.glsl_transformer.ast.traversal.ASTWalker;
import io.github.douira.glsl_transformer.util.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.irisshaders.iris.gl.shader.ShaderType;
import net.irisshaders.iris.pipeline.transform.PatchShaderType;

public class IrisPatcher {
    public static ThreadLocal<String> currentShaderName = ThreadLocal.withInitial(() -> null);
    private static final Set<String> sorterWhitelist = new HashSet<String>(){
        {
            this.add("getVertexPosition");
            this.add("u_RegionOffset");
            this.add("_get_draw_translation");
            this.add("_get_relative_chunk_coord");
        }
    };
    private static final Pattern versionPattern = Pattern.compile("#version\\s+(\\d+)", 32);
    private static final ASTTransformer<Parameters, String> transformer = new ASTTransformer<Parameters, String>(){
        {
            this.setRootSupplier(RootSupplier.PREFIX_UNORDERED_ED_EXACT);
        }

        public TranslationUnit parseTranslationUnit(Root rootInstance, String input) {
            Matcher matcher = versionPattern.matcher(input);
            if (matcher.find()) {
                IrisPatcher.transformer.getLexer().version = Version.fromNumber((int)Integer.parseInt(matcher.group(1)));
            }
            return super.parseTranslationUnit(rootInstance, input);
        }

        public String transform(RootSupplier rootSupplier, String input) {
            TranslationUnit tree = this.parseTranslationUnit(rootSupplier, input);
            Root root = tree.getRoot();
            root.indexBuildSession(() -> IrisPatcher.internalInjectVarsAndDummyAPI(transformer, tree, (Parameters)this.getJobParameters()));
            return ASTPrinter.print((PrintType)this.getPrintType(), (ASTNode)tree);
        }
    };

    private static void internalInjectVarsAndDummyAPI(ASTParser t, TranslationUnit tree, Parameters parameters) {
        if (IrisPatcher.hasFn(tree, "_cfi_injected")) {
            return;
        }
        FadeShader shader = new FadeShader();
        boolean inject = !IrisPatcher.hasFn(tree, "_cfi_noInjectMarker");
        switch (parameters.type) {
            case VERTEX: {
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.vertInVars().flushList().stream());
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{shader.dummyApiVertGetFadeData().flushSingleLine(), shader.dummyApiVertCalculateDisplacement().flushSingleLine(), shader.dummyApiVertCalculateDisplacement2().flushSingleLine(), shader.dummyApiVertCalculateCurvature().flushSingleLine(), shader.dummyApiVertCalculateCurvature2().flushSingleLine()});
                if (!inject) break;
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.vertOutVars().flushList().stream());
                break;
            }
            case FRAGMENT: {
                if (!inject) break;
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{shader.dummyApiFragCalculateFade().flushSingleLine(), shader.dummyApiFragApplyFade().flushSingleLine(), shader.dummyApiFragApplyFogFade().flushSingleLine(), shader.dummyApiFragApplySkyLodFade().flushSingleLine(), shader.dummyApiFragSampleSkyLodTexture().flushSingleLine()});
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.fragInVars().flushList().stream());
                break;
            }
            default: {
                return;
            }
        }
        tree.parseAndInjectNodes(t, ASTInjectionPoint.END, new String[]{"void _cfi_injected() {}"});
    }

    public static String injectVarsAndDummyAPI(PatchShaderType type, String source) {
        if (source.contains("_cfi_ignoreMarker") || !source.contains("cfi_") && !source.contains("CFI_") && !source.contains("CHUNKS_FADE_IN_")) {
            return source;
        }
        transformer.setJobParameters((JobParameters)new Parameters(type));
        return (String)transformer.transform((Object)source);
    }

    public static void injectModAndAPI(ASTParser t, TranslationUnit tree, Root root, ShaderType glShaderType) {
        FadeShader shader = new FadeShader();
        boolean injected = IrisPatcher.hasFn(tree, "_cfi_injected");
        boolean inject = !IrisPatcher.hasFn(tree, "_cfi_noInjectMarker");
        boolean injectMod = !IrisPatcher.hasFn(tree, "_cfi_noInjectModMarker");
        boolean injectFragMod = injectMod && !IrisPatcher.hasFn(tree, "_cfi_noInjectFragModMarker");
        boolean injectVertMod = injectMod && !IrisPatcher.hasFn(tree, "_cfi_noInjectVertModMarker");
        boolean injectCurvature = injectMod && !IrisPatcher.hasFn(tree, "_cfi_noCurvatureMarker");
        switch (glShaderType) {
            case VERTEX: {
                IrisPatcher.removeFn(tree, "cfi_getFadeData");
                IrisPatcher.removeFn(tree, "cfi_calculateDisplacement");
                IrisPatcher.removeFn(tree, "cfi_calculateCurvature");
                if (!injected) {
                    tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.vertInVars().flushList().stream());
                }
                tree.injectNodes(ASTInjectionPoint.BEFORE_FUNCTIONS, IrisPatcher.parseDeclarations(t, root, shader.apiVertGetFadeData("_draw_id").flushSingleLine(), shader.apiVertCalculateDisplacement().flushSingleLine(), shader.apiVertCalculateDisplacement2().flushSingleLine(), shader.apiVertCalculateCurvature().flushSingleLine(), shader.apiVertCalculateCurvature2().flushSingleLine()));
                if (!inject) break;
                shader.newLine("vec3 position = getVertexPosition().xyz;").vertInitOutVarsDrawId("_vert_position", "_draw_id");
                if (injectVertMod) {
                    shader.vertInitMod("_vert_position", "position", true, "vec3(_draw_id)", injectCurvature);
                }
                tree.appendFunctionBody("_vert_init", IrisPatcher.parseStatements(t, root, shader.flushArray()));
                if (injected) break;
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.vertOutVars().flushList().stream());
                break;
            }
            case FRAGMENT: {
                if (!inject) {
                    return;
                }
                IrisPatcher.removeFn(tree, "cfi_sampleSkyLodTexture");
                IrisPatcher.removeFn(tree, "cfi_applySkyLodFade");
                IrisPatcher.removeFn(tree, "cfi_applyFogFade");
                IrisPatcher.removeFn(tree, "cfi_applyFade");
                IrisPatcher.removeFn(tree, "cfi_calculateFade");
                tree.injectNodes(ASTInjectionPoint.BEFORE_FUNCTIONS, IrisPatcher.parseDeclarations(t, root, shader.apiFragCalculateFade().flushSingleLine(), shader.apiFragApplyFade().flushSingleLine(), shader.apiFragApplyFogFade().flushSingleLine(), shader.apiFragApplySkyLodFade().flushSingleLine(), shader.apiFragSampleSkyLodTexture().flushSingleLine()));
                if (!injected) {
                    tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, shader.fragInVars().flushList().stream());
                }
                if (!injectFragMod) break;
                IrisPatcher.injectFragMod(t, tree, root);
                break;
            }
        }
        IrisPatcher.sortUses(tree);
    }

    public static void injectFragMod(ASTParser t, TranslationUnit tree, Root root) {
        List<Layout> layouts = IrisPatcher.findOutputColors(tree);
        if (layouts.isEmpty()) {
            return;
        }
        FadeShader shader = new FadeShader();
        Layout first = layouts.getFirst();
        Type type = first.type;
        String name = first.name;
        List<String> packers = root.identifierIndex.index.keySet().stream().filter(s -> s.contains("pack")).toList();
        if (packers.isEmpty()) {
            if (type == Type.FLOAT32) {
                tree.appendMainFunctionBody(IrisPatcher.parseStatements(t, root, shader.calculateFade("float fade = ").newLine(name + " *= fade;").flushMultiline()));
            }
            if (type == Type.F32VEC3 || type == Type.F32VEC4) {
                tree.appendMainFunctionBody(IrisPatcher.parseStatements(t, root, shader.fragColorMod(name + ".rgb").flushMultiline()));
            }
            return;
        }
        HashMap<FunctionDefinition, Map> vars = new HashMap<FunctionDefinition, Map>();
        packers.forEach(packer -> root.identifierIndex.get(packer).forEach(i -> {
            AssignmentExpression assignment = (AssignmentExpression)i.getAncestor(AssignmentExpression.class);
            if (assignment == null) {
                return;
            }
            Expression patt0$temp = assignment.getLeft();
            if (!(patt0$temp instanceof MemberAccessExpression)) {
                return;
            }
            MemberAccessExpression memberAccess = (MemberAccessExpression)patt0$temp;
            Expression patt1$temp = memberAccess.getOperand();
            if (!(patt1$temp instanceof ReferenceExpression)) {
                return;
            }
            ReferenceExpression ref = (ReferenceExpression)patt1$temp;
            if (!name.equals(ref.getIdentifier().getName())) {
                return;
            }
            String member = memberAccess.getMember().getName();
            if (!"xyzwrgba".contains(member)) {
                return;
            }
            FunctionCallExpression call = (FunctionCallExpression)i.getAncestor(FunctionCallExpression.class);
            if (call == null) {
                return;
            }
            for (Expression param : call.getParameters()) {
                String paramMember;
                ReferenceExpression paramRef;
                String varName;
                MemberAccessExpression paramAccess;
                Expression patt2$temp;
                if (!(param instanceof MemberAccessExpression) || !((patt2$temp = (paramAccess = (MemberAccessExpression)param).getOperand()) instanceof ReferenceExpression) || !(varName = (paramRef = (ReferenceExpression)patt2$temp).getIdentifier().getName()).contains("color") || !"xyzwrgba".contains(paramMember = paramAccess.getMember().getName())) continue;
                FunctionDefinition fn = (FunctionDefinition)assignment.getAncestor(FunctionDefinition.class);
                ChildNodeList body = fn.getBody().getStatements();
                int idx = body.indexOf((Object)assignment.getAncestor(Statement.class));
                Map fnVars = vars.computeIfAbsent(fn, k -> new HashMap());
                MixVar var = (MixVar)fnVars.get(varName);
                if (var == null) {
                    fnVars.put(varName, new MixVar(varName, paramMember, idx));
                    continue;
                }
                var.components = var.components + paramMember;
                var.firstUse = Math.min(var.firstUse, idx);
            }
        }));
        vars.forEach((fn, vs) -> {
            ChildNodeList body = fn.getBody().getStatements();
            vs.values().forEach(v -> body.addAll(v.firstUse, IrisPatcher.parseStatements(t, root, shader.fragColorMod(v.name + "." + v.components, "iris_FogColor." + v.components).flushMultiline())));
        });
    }

    public static void sortUses(TranslationUnit tree) {
        for (int a = 0; a < 2; ++a) {
            tree.getRoot().identifierIndex.index.entrySet().stream().filter(e -> sorterWhitelist.contains(e.getKey()) || ((String)e.getKey()).startsWith("_cfi_") || !((String)e.getKey()).startsWith("_") && ((String)e.getKey()).contains("cfi_")).forEach(e -> {
                ChildNodeList children = tree.getChildren();
                FunctionDefinition declaration = null;
                int firstUseIdx = -1;
                for (Identifier id : (Set)e.getValue()) {
                    InterfaceBlockDeclaration intDeclaration;
                    Declaration patt0$temp;
                    FunctionDefinition fnDefinition = (FunctionDefinition)id.getBranchAncestor(FunctionDefinition.class, FunctionDefinition::getFunctionPrototype);
                    DeclarationExternalDeclaration externalDeclaration = (DeclarationExternalDeclaration)id.getBranchAncestor(DeclarationExternalDeclaration.class, DeclarationExternalDeclaration::getDeclaration);
                    if (externalDeclaration != null && ((String)e.getKey()).equals("cfi_ChunkFadeData") && (patt0$temp = externalDeclaration.getDeclaration()) instanceof InterfaceBlockDeclaration && !(intDeclaration = (InterfaceBlockDeclaration)patt0$temp).getBlockName().getName().equals(e.getKey())) {
                        externalDeclaration = null;
                    }
                    if (fnDefinition == null && externalDeclaration == null) {
                        int i;
                        ExternalDeclaration child = (ExternalDeclaration)id.getAncestor(FunctionDefinition.class);
                        if (child == null) {
                            child = (ExternalDeclaration)id.getAncestor(DeclarationExternalDeclaration.class);
                        }
                        if ((i = children.indexOf((Object)child)) != -1 && (firstUseIdx == -1 || firstUseIdx > i)) {
                            firstUseIdx = i;
                        }
                    }
                    if (declaration != null) continue;
                    if (fnDefinition != null) {
                        declaration = fnDefinition;
                        continue;
                    }
                    if (externalDeclaration == null) continue;
                    declaration = externalDeclaration;
                }
                if (firstUseIdx == -1) {
                    return;
                }
                if (declaration != null && children.indexOf(declaration) > firstUseIdx) {
                    declaration.detach();
                    children.add(firstUseIdx, declaration);
                }
            });
        }
    }

    private static List<Layout> findOutputColors(TranslationUnit tree) {
        final ArrayList<Layout> colors = new ArrayList<Layout>();
        ASTListener listener = new ASTListener(){

            public void enterTypeAndInitDeclaration(TypeAndInitDeclaration declaration) {
                FullySpecifiedType fullType = declaration.getType();
                TypeSpecifier typeSpecifier = fullType.getTypeSpecifier();
                if (!(typeSpecifier instanceof BuiltinNumericTypeSpecifier)) {
                    return;
                }
                BuiltinNumericTypeSpecifier numSpecifier = (BuiltinNumericTypeSpecifier)typeSpecifier;
                TypeQualifier typeQualifier = fullType.getTypeQualifier();
                if (typeQualifier == null) {
                    return;
                }
                for (TypeQualifierPart part : typeQualifier.getParts()) {
                    if (!(part instanceof LayoutQualifier)) continue;
                    LayoutQualifier qualifier = (LayoutQualifier)part;
                    for (LayoutQualifierPart layoutPart : qualifier.getParts()) {
                        NamedLayoutQualifierPart namedPart;
                        Expression expression;
                        if (!(layoutPart instanceof NamedLayoutQualifierPart) || !((expression = (namedPart = (NamedLayoutQualifierPart)layoutPart).getExpression()) instanceof LiteralExpression)) continue;
                        LiteralExpression idxExpr = (LiteralExpression)expression;
                        int idx = (int)idxExpr.getInteger();
                        if (idx >= colors.size()) {
                            colors.addAll(Collections.nCopies(idx - colors.size() + 1, null));
                        }
                        colors.add(idx, new Layout(numSpecifier.type, ((DeclarationMember)declaration.getMembers().getFirst()).getName().getName()));
                    }
                }
            }
        };
        ASTWalker.walk((ASTListener)listener, (ASTNode)tree);
        return colors;
    }

    private static void removeFn(TranslationUnit tree, String name) {
        try {
            for (int i = 0; i < 2; ++i) {
                tree.getOneFunctionDefinitionBody(name).getParent().detachAndDelete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasFn(TranslationUnit tree, String name) {
        try {
            tree.getOneFunctionDefinitionBody(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<ExternalDeclaration> parseDeclarations(ASTParser t, Root root, String ... input) {
        if (input.length == 0 || Arrays.stream(input).allMatch(String::isBlank)) {
            return List.of();
        }
        return t.parseExternalDeclarations(root, input);
    }

    public static List<Statement> parseStatements(ASTParser t, Root root, String ... input) {
        if (input.length == 0 || Arrays.stream(input).allMatch(String::isBlank)) {
            return List.of();
        }
        return t.parseStatements(root, input);
    }

    private record Parameters(PatchShaderType type) implements JobParameters
    {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Parameters) {
                Parameters other = (Parameters)obj;
                return this.type == other.type;
            }
            return false;
        }
    }

    private record Layout(Type type, String name) {
    }

    private static class MixVar {
        private String name;
        private String components;
        private int firstUse;

        private MixVar(String name, String components, int firstUse) {
            this.name = name;
            this.components = components;
            this.firstUse = firstUse;
        }

        public String toString() {
            return "MixVar{name='" + this.name + "', components='" + this.components + "', firstUse=" + this.firstUse + "}";
        }
    }
}

